/*
 * Decompiled with CFR 0.152.
 */
package gg.packetloss.Pitfall.config;

import gg.packetloss.Pitfall.LocalConfiguration;
import gg.packetloss.Pitfall.util.yaml.YAMLProcessor;
import java.util.logging.FileHandler;
import java.util.logging.Logger;

public class YAMLConfiguration
extends LocalConfiguration {
    public final YAMLProcessor config;
    protected final Logger logger;
    private FileHandler logFileHandler;

    public YAMLConfiguration(YAMLProcessor config, Logger logger) {
        this.config = config;
        this.logger = logger;
    }

    @Override
    public void load() {
        this.useBlackList = this.config.getBoolean("blacklist.enable", true);
        this.ignorePassable = this.config.getBoolean("blacklist.ignore-passible", true);
        this.maxRadius = this.config.getInt("limits.max-radius", 5);
        this.destrutiveHeight = this.config.getInt("limits.destructive-height", 1);
        this.checkFrequency = this.config.getInt("check-frequency", 5);
        this.trapDelay = this.config.getInt("trap-delay", 2);
        this.returnDelay = this.config.getInt("return-delay", 60);
        this.eagerMode = this.config.getBoolean("eager-mode", true);
        this.enableItemTrap = this.config.getBoolean("enable-item-detection", true);
        this.enableMonsterTrap = this.config.getBoolean("enable-monster-detection", true);
        this.ignoreSpectators = this.config.getBoolean("ignore-spectators", true);
        this.checkPitfallPermission = this.config.getBoolean("check-pitfall-permission", false);
        this.config.save();
    }

    public void unload() {
        if (this.logFileHandler != null) {
            this.logFileHandler.close();
        }
    }
}

