/*
 * Decompiled with CFR 0.152.
 */
package gg.packetloss.Pitfall.bukkit;

import gg.packetloss.Pitfall.LocalConfiguration;
import gg.packetloss.Pitfall.bukkit.BukkitConfiguration;
import gg.packetloss.Pitfall.bukkit.PitfallBukkitWorker;
import gg.packetloss.Pitfall.util.yaml.YAMLFormat;
import gg.packetloss.Pitfall.util.yaml.YAMLProcessor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PitfallPlugin
extends JavaPlugin {
    private static PitfallPlugin inst;
    private BukkitConfiguration config;
    private PitfallBukkitWorker pitfallBukkitWorker;

    public void onLoad() {
        inst = this;
    }

    public void onEnable() {
        this.createDefaultConfiguration(new File(this.getDataFolder(), "config.yml"), "config.yml", false);
        this.config = new BukkitConfiguration(new YAMLProcessor(new File(this.getDataFolder(), "config.yml"), true, YAMLFormat.EXTENDED));
        this.config.load();
        this.getLogger().info(this.getDescription().getName() + " " + this.getDescription().getVersion() + " enabled.");
        this.pitfallBukkitWorker = new PitfallBukkitWorker();
        this.pitfallBukkitWorker.setDefaultTrapDelay(this.config.trapDelay);
        this.pitfallBukkitWorker.setDefaultReturnDelay(this.config.returnDelay);
        this.pitfallBukkitWorker.setEagerMode(this.config.eagerMode);
        this.pitfallBukkitWorker.activateItemCheck(this.config.enableItemTrap);
        this.pitfallBukkitWorker.activateCreatureCheck(this.config.enableMonsterTrap);
        this.pitfallBukkitWorker.setMaxRadius(this.config.maxRadius);
        this.pitfallBukkitWorker.setDestructiveHeight(this.config.destrutiveHeight);
        this.pitfallBukkitWorker.setTargetBlock(this.config.targetType);
        this.pitfallBukkitWorker.setIgnoreSpectators(this.config.ignoreSpectators);
        this.pitfallBukkitWorker.setCheckPermissions(this.config.checkPitfallPermission);
        if (this.config.useBlackList) {
            Set blackList = this.pitfallBukkitWorker.getBlackList();
            blackList.addAll(this.config.blackListedBlocks);
            if (this.config.ignorePassable) {
                for (Material material : Material.values()) {
                    if (!material.isBlock() || material.isSolid()) continue;
                    blackList.add(material);
                }
            }
        }
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)this.pitfallBukkitWorker, 60L, (long)this.config.checkFrequency);
    }

    public void onDisable() {
        this.pitfallBukkitWorker.revertAll();
        this.getLogger().info(this.getDescription().getName() + " disabled.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDefaultConfiguration(File actual, String defaultName, boolean force) {
        File parent = actual.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if (actual.exists() && !force) {
            return;
        }
        InputStream input = null;
        JarFile file = null;
        try {
            file = new JarFile(this.getFile());
            ZipEntry copy = file.getEntry("defaults/" + defaultName);
            if (copy == null) {
                file.close();
                throw new FileNotFoundException();
            }
            input = file.getInputStream(copy);
        }
        catch (IOException e) {
            this.getLogger().severe("Unable to read default configuration: " + defaultName);
        }
        if (input != null) {
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(actual);
                byte[] buf = new byte[8192];
                int length = 0;
                while ((length = input.read(buf)) > 0) {
                    output.write(buf, 0, length);
                }
                if (!force) {
                    this.getLogger().info("Default configuration file written: " + actual.getAbsolutePath());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    file.close();
                }
                catch (IOException iOException) {}
                try {
                    input.close();
                }
                catch (IOException iOException) {}
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static PitfallPlugin inst() {
        return inst;
    }

    public LocalConfiguration getLocalConfiguration() {
        return this.config;
    }

    public PitfallBukkitWorker getPitfallWorker() {
        return this.pitfallBukkitWorker;
    }
}

