/*
 * Decompiled with CFR 0.152.
 */
package gg.packetloss.Pitfall.bukkit;

import gg.packetloss.Pitfall.PitfallBlockChange;
import gg.packetloss.Pitfall.PitfallWorker;
import gg.packetloss.Pitfall.Point;
import gg.packetloss.Pitfall.bukkit.PitfallBukkitEditor;
import gg.packetloss.Pitfall.bukkit.PitfallPlugin;
import gg.packetloss.Pitfall.bukkit.event.PitfallBlockChangeEvent;
import gg.packetloss.Pitfall.bukkit.event.PitfallTriggerEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Flying;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.WaterMob;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class PitfallBukkitWorker
extends PitfallWorker<World, Material> {
    private static final PitfallPlugin plugin = PitfallPlugin.inst();
    private static final Server server = plugin.getServer();
    private static final Logger log = plugin.getLogger();
    private Set<PitfallBukkitEditor> records = new CopyOnWriteArraySet<PitfallBukkitEditor>();
    private Set<Class<? extends Entity>> targeted = new HashSet<Class<? extends Entity>>();
    private int defaultTrapDelay = 2;
    private int defaultReturnDelay = 60;

    public PitfallBukkitWorker() {
        this.targeted.add(Player.class);
        this.blackListedBlocks.add(Material.AIR);
    }

    @Override
    public void revertAll() {
        for (PitfallBukkitEditor record : this.records) {
            record.revertAll();
        }
        this.records.clear();
    }

    private boolean checkFromPosition(Location location) {
        location = location.clone();
        Block h = location.add(0.0, -1.0, 0.0).getBlock();
        Block b = location.add(0.0, -1.0, 0.0).getBlock();
        Material hMat = h.getType();
        Material bMat = b.getType();
        return ((Material)this.targetBlock).equals((Object)bMat) && !this.checkBlackList(hMat);
    }

    private void activateAtBlock(Entity entity, Location location) {
        Block triggeringBlock = location.clone().add(0.0, -2.0, 0.0).getBlock();
        PitfallTriggerEvent event = new PitfallTriggerEvent(entity, triggeringBlock, this.defaultTrapDelay, this.defaultReturnDelay);
        server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        server.getScheduler().runTaskLater((Plugin)plugin, () -> {
            PitfallBukkitEditor record = new PitfallBukkitEditor(location.getWorld());
            Block b1 = event.getBlock();
            this.trigger(record, new Point(b1.getX(), b1.getY(), b1.getZ()));
            this.records.add(record);
            server.getScheduler().runTaskLater((Plugin)plugin, () -> {
                if (!this.records.contains(record)) {
                    return;
                }
                record.revertAll();
                this.records.remove(record);
            }, (long)event.getReturnDelay());
        }, (long)event.getTriggerDelay());
    }

    private boolean isChunkLoaded(Location location) {
        return location.getWorld().isChunkLoaded(location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    private boolean testIfLoaded(Location location, Predicate<Location> consumer) {
        if (!this.isChunkLoaded(location)) {
            return false;
        }
        return consumer.test(location.clone());
    }

    private void getCheckLocations(Entity entity, Predicate<Location> consumer) {
        Location location = entity.getLocation();
        if (this.testIfLoaded(location.clone(), consumer)) {
            return;
        }
        if (!this.eagerMode || entity.getType() != EntityType.PLAYER) {
            return;
        }
        for (double xMod : new double[]{0.0, 0.4, -0.4}) {
            for (double zMod : new double[]{0.0, 0.4, -0.4}) {
                Location testLoc = location.clone().add(xMod, 0.0, zMod);
                if (testLoc.getBlockX() == location.getBlockX() && testLoc.getBlockZ() == location.getBlockZ() || !this.testIfLoaded(testLoc, consumer)) continue;
                return;
            }
        }
    }

    @Override
    public void run() {
        for (World world : plugin.getServer().getWorlds()) {
            for (Entity entity : world.getEntitiesByClasses(this.targeted.toArray(new Class[0]))) {
                double entityY;
                if (entity instanceof WaterMob || entity instanceof Flying) continue;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (this.ignoreSpectators && player.getGameMode() == GameMode.SPECTATOR || player.isSwimming() || this.checkPermissions && !player.hasPermission("pitfall.trigger")) continue;
                }
                if ((entityY = entity.getLocation().getY()) != Math.floor(entityY)) continue;
                this.getCheckLocations(entity, testLoc -> {
                    if (this.checkFromPosition((Location)testLoc)) {
                        this.activateAtBlock(entity, (Location)testLoc);
                        return true;
                    }
                    return false;
                });
            }
        }
    }

    @Override
    public void activateItemCheck(boolean enable) {
        if (enable) {
            this.targeted.add(Item.class);
        } else {
            this.targeted.remove(Item.class);
        }
    }

    @Override
    public void activateCreatureCheck(boolean enable) {
        if (enable) {
            this.targeted.add(LivingEntity.class);
        } else {
            this.targeted.remove(LivingEntity.class);
        }
    }

    @Override
    public boolean checkBlackList(Material type) {
        return this.blackListedBlocks.contains(type);
    }

    @Override
    protected PitfallBlockChange<Material> callEvent(World world, Point pt) {
        return new PitfallBlockChangeEvent(new Location(world, (double)pt.getX(), (double)pt.getY(), (double)pt.getZ()));
    }

    public void setDefaultTrapDelay(int delay) {
        this.defaultTrapDelay = delay;
    }

    public void setDefaultReturnDelay(int delay) {
        this.defaultReturnDelay = delay;
    }
}

