/*
 * Decompiled with CFR 0.152.
 */
package gg.packetloss.Pitfall;

import gg.packetloss.Pitfall.PitfallBlockChange;
import gg.packetloss.Pitfall.PitfallEditor;
import gg.packetloss.Pitfall.Point;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public abstract class PitfallWorker<World, Type>
implements Runnable {
    protected int maxRadius = 3;
    protected int destructiveHeight = 1;
    protected Type targetBlock;
    protected Set<Type> blackListedBlocks = new HashSet<Type>();
    protected boolean ignoreSpectators = true;
    protected boolean checkPermissions = false;
    protected boolean eagerMode = false;

    public abstract void revertAll();

    public abstract void activateItemCheck(boolean var1);

    public abstract void activateCreatureCheck(boolean var1);

    public void setMaxRadius(int radius) {
        this.maxRadius = radius;
    }

    public void setDestructiveHeight(int destructiveHeight) {
        this.destructiveHeight = destructiveHeight;
    }

    public void setTargetBlock(Type targetedBlock) {
        this.targetBlock = targetedBlock;
    }

    public abstract boolean checkBlackList(Type var1);

    public Set<Type> getBlackList() {
        return this.blackListedBlocks;
    }

    public void setIgnoreSpectators(boolean ignoreSpectators) {
        this.ignoreSpectators = ignoreSpectators;
    }

    public void setCheckPermissions(boolean checkPermissions) {
        this.checkPermissions = checkPermissions;
    }

    public void setEagerMode(boolean eagerMode) {
        this.eagerMode = eagerMode;
    }

    public int trigger(PitfallEditor<World, Type> editor, Point origin) {
        int affected = 0;
        int originX = origin.getX();
        int originZ = origin.getZ();
        HashSet<Point> visited = new HashSet<Point>();
        Stack<Point> queue = new Stack<Point>();
        queue.push(origin.clone());
        while (!queue.empty()) {
            Type above;
            Point pt = (Point)queue.pop();
            int cx = pt.getX();
            int cz = pt.getZ();
            if (visited.contains(pt)) continue;
            visited.add(pt);
            double dist = Math.max(Math.abs(cx - originX), Math.abs(cz - originZ));
            if (dist > (double)this.maxRadius || !this.targetBlock.equals(editor.getAt(pt)) || this.checkBlackList(above = editor.getAt(pt.withY(pt.getY() + 1)))) continue;
            affected += this.triggerVert(editor, pt);
            queue.push(pt.withX(cx + 1));
            queue.push(pt.withX(cx - 1));
            queue.push(pt.withZ(cz + 1));
            queue.push(pt.withZ(cz - 1));
        }
        return affected;
    }

    public int triggerVert(PitfallEditor<World, Type> editor, Point origin) {
        int affected = 0;
        int originY = origin.getY();
        Stack<Point> queue = new Stack<Point>();
        queue.push(origin.clone());
        while (!queue.isEmpty()) {
            Type above;
            Point pt = (Point)queue.pop();
            int cy = pt.getY();
            if (cy < editor.getMinY() || cy < originY || cy > originY + this.destructiveHeight || cy > editor.getMaxY() || this.checkBlackList(above = editor.getAt(pt)) && cy != originY) continue;
            PitfallBlockChange<Type> event = this.callEvent(editor.getWorld(), pt);
            if (event.isAllowed()) {
                editor.edit(event.getTargetPoint(), event.getNewType());
                ++affected;
            }
            queue.push(pt.withY(cy + 1));
        }
        return affected;
    }

    protected abstract PitfallBlockChange<Type> callEvent(World var1, Point var2);
}

