/*
 * Decompiled with CFR 0.152.
 */
package gg.packetloss.mcmailbox;

import gg.packetloss.mcmailbox.MCMailboxThread;
import gg.packetloss.mcmailbox.MailBoxUpdateEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;

public class MCMailBoxPlugin
extends JavaPlugin {
    private final Map<String, String> keyValueStore = new HashMap<String, String>();
    private Logger logger;
    private MCMailboxThread mailThread;

    public void onEnable() {
        this.logger = this.getLogger();
        this.mailThread = new MCMailboxThread(this);
        this.mailThread.start();
        this.logger.info("Enabled!");
    }

    public void onDisable() {
        this.destroyMailThreadIfRunning();
        this.logger.info("Disabled.");
    }

    private void destroyMailThreadIfRunning() {
        if (this.mailThread != null) {
            this.mailThread.destroy();
            this.mailThread = null;
        }
    }

    public String getValue(String key) {
        return this.keyValueStore.getOrDefault(key, "");
    }

    public String getValueOrDefault(String key, String defaultValue) {
        return this.keyValueStore.getOrDefault(key, defaultValue);
    }

    public void putValue(String key, String value) {
        new MailBoxUpdateEvent(key, this.getValue(key), value);
        this.keyValueStore.put(key, value);
    }
}

