/*
 * Decompiled with CFR 0.152.
 */
package gg.packetloss.hackbook;

import gg.packetloss.hackbook.DataMigrator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class ItemSerializer {
    private static RegistryAccess.Frozen getRegistry() {
        return MinecraftServer.getServer().registryAccess();
    }

    private static CompoundTag toTag(ItemStack stack) {
        CompoundTag compound = new CompoundTag();
        if (stack == null || stack.getType().isAir()) {
            compound.put("HACKBOOK_AIR_ITEM", (Tag)IntTag.valueOf((int)1));
        } else {
            CraftItemStack.asNMSCopy((ItemStack)stack).save((HolderLookup.Provider)ItemSerializer.getRegistry(), (Tag)compound);
        }
        return compound;
    }

    public static String toJSON(ItemStack stack) {
        return ItemSerializer.toTag(stack).toString();
    }

    public static void writeToOutputStream(ItemStack stack, OutputStream stream) throws IOException {
        NbtIo.writeCompressed((CompoundTag)ItemSerializer.toTag(stack), (OutputStream)stream);
    }

    public static void writeToOutputStream(Collection<ItemStack> stacks, OutputStream stream) throws IOException {
        CompoundTag compoundTag = new CompoundTag();
        ListTag tag = new ListTag();
        for (ItemStack stack : stacks) {
            tag.add((Object)ItemSerializer.toTag(stack));
        }
        compoundTag.put("elements", (Tag)tag);
        compoundTag.putInt("DataVersion", DataMigrator.getCurrentVersion());
        NbtIo.writeCompressed((CompoundTag)compoundTag, (OutputStream)stream);
    }

    public static List<ItemStack> fromInputStream(InputStream stream, boolean migrate) throws IOException {
        CompoundTag compoundTag = NbtIo.readCompressed((InputStream)stream, (NbtAccounter)NbtAccounter.unlimitedHeap());
        ListTag tag = (ListTag)compoundTag.get("elements");
        Validate.isTrue((boolean)compoundTag.contains("DataVersion"));
        int prevVersion = compoundTag.getInt("DataVersion");
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(tag.size());
        for (int i = 0; i < tag.size(); ++i) {
            Optional optItem;
            CompoundTag itemTag = tag.getCompound(i);
            if (itemTag.contains("HACKBOOK_AIR_ITEM")) {
                stacks.add(new ItemStack(Material.AIR));
                continue;
            }
            if (migrate) {
                itemTag = DataMigrator.updateItemStack(prevVersion, itemTag);
            }
            if ((optItem = net.minecraft.world.item.ItemStack.parse((HolderLookup.Provider)ItemSerializer.getRegistry(), (Tag)itemTag)).isPresent()) {
                stacks.add((ItemStack)CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)optItem.get())));
                continue;
            }
            stacks.add(new ItemStack(Material.AIR));
        }
        return stacks;
    }

    public static List<ItemStack> fromInputStream(InputStream stream) throws IOException {
        return ItemSerializer.fromInputStream(stream, false);
    }
}

