/*
 * Decompiled with CFR 0.152.
 */
package com.zachsthings.libcomponents;

import com.zachsthings.libcomponents.AbstractComponent;
import com.zachsthings.libcomponents.AnnotationHandler;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.ComponentRegistrationState;
import com.zachsthings.libcomponents.Depend;
import com.zachsthings.libcomponents.InvalidComponentException;
import com.zachsthings.libcomponents.loader.ComponentLoader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class ComponentManager<T extends AbstractComponent> {
    protected final Logger logger;
    protected final Class<T> componentClass;
    protected final List<ComponentLoader> loaders = new ArrayList<ComponentLoader>();
    protected final Map<Class<? extends Annotation>, AnnotationHandler<Annotation>> annotationHandlers = new HashMap<Class<? extends Annotation>, AnnotationHandler<Annotation>>();
    protected final Map<String, ComponentRegistrationState<T>> registeredComponentsByName = new HashMap<String, ComponentRegistrationState<T>>();
    protected final Map<Class<?>, ComponentRegistrationState<T>> registeredComponentsByClass = new HashMap();
    protected final List<ComponentRegistrationState<T>> registeredComponents = new ArrayList<ComponentRegistrationState<T>>();
    protected final Set<String> requiredPlugins = new HashSet<String>();

    public ComponentManager(Logger logger, Class<T> componentCass) {
        this.logger = logger;
        this.componentClass = componentCass;
    }

    public synchronized boolean addComponentLoader(ComponentLoader loader) {
        return this.loaders.add(loader);
    }

    private String standardizeName(String friendlyName) {
        return friendlyName.replaceAll(" ", "-").toLowerCase();
    }

    public synchronized boolean loadComponents() throws InvalidComponentException {
        for (ComponentLoader loader : this.loaders) {
            for (AbstractComponent baseComponent : loader.loadComponents()) {
                if (!this.componentClass.isAssignableFrom(baseComponent.getClass())) {
                    throw new InvalidComponentException(baseComponent.getClass(), "Component is not an instance of " + this.componentClass.getCanonicalName());
                }
                AbstractComponent component = (AbstractComponent)this.componentClass.cast(baseComponent);
                Class<?> componentClass = component.getClass();
                ComponentInformation info = componentClass.getAnnotation(ComponentInformation.class);
                component.setUp(loader, info);
                this.setUpComponent(component);
                Depend dependencyInfo = componentClass.getAnnotation(Depend.class);
                ComponentRegistrationState<AbstractComponent> registrationState = new ComponentRegistrationState<AbstractComponent>(component, dependencyInfo);
                this.registeredComponents.add(registrationState);
                this.registeredComponentsByName.put(this.standardizeName(info.friendlyName()), registrationState);
                this.registeredComponentsByClass.put(componentClass, registrationState);
            }
        }
        return true;
    }

    protected abstract void setUpComponent(T var1);

    protected abstract boolean isPluginRegistered(String var1);

    protected abstract boolean isPluginEnabled(String var1);

    public void handlePluginEnable(String pluginName) {
        if (this.requiredPlugins.contains(pluginName)) {
            this.enableComponents();
        }
    }

    private synchronized boolean hasDependenciesMet(ComponentRegistrationState<T> registrationState) {
        Depend dependencyInfo = registrationState.getDependencyInfo();
        if (dependencyInfo == null) {
            return true;
        }
        T component = registrationState.getComponent();
        for (Class<?> dependentComponent : dependencyInfo.components()) {
            ComponentRegistrationState<T> dependencyState = this.registeredComponentsByClass.get(dependentComponent);
            if (dependencyState == null) {
                registrationState.setBroken(true);
                this.logger.log(Level.WARNING, "Component " + ((AbstractComponent)component).getInformation().friendlyName() + " could not be enabled! Dependent component was not present " + dependentComponent.getCanonicalName());
                continue;
            }
            if (dependencyState.isEnabled()) continue;
            return false;
        }
        for (String dependentPlugin : dependencyInfo.plugins()) {
            if (!this.isPluginRegistered(dependentPlugin)) {
                registrationState.setBroken(true);
                this.logger.log(Level.WARNING, "Component " + ((AbstractComponent)component).getInformation().friendlyName() + " could not be enabled! Dependent plugin was not present " + (String)dependentPlugin);
                continue;
            }
            if (this.isPluginEnabled(dependentPlugin)) continue;
            this.requiredPlugins.add(dependentPlugin);
            return false;
        }
        return true;
    }

    private synchronized boolean enableComponent(ComponentRegistrationState<T> registrationState) {
        T component = registrationState.getComponent();
        try {
            for (Field field : component.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                for (Annotation annotation : field.getAnnotations()) {
                    AnnotationHandler<Annotation> handler = this.annotationHandlers.get(annotation.annotationType());
                    if (handler == null || handler.handle((AbstractComponent)component, field, annotation)) continue;
                    registrationState.setBroken(true);
                    this.logger.log(Level.WARNING, "Component " + ((AbstractComponent)component).getInformation().friendlyName() + " could not be enabled! Error in annotation handler for field " + field);
                }
            }
            if (registrationState.isBroken()) {
                return false;
            }
            ((AbstractComponent)component).enable();
            ((AbstractComponent)component).setEnabled(true);
            ((AbstractComponent)component).saveConfig();
            this.logger.log(Level.FINEST, "Component " + ((AbstractComponent)component).getInformation().friendlyName() + " successfully enabled!");
            registrationState.setEnabled(true);
            return true;
        }
        catch (Throwable t) {
            registrationState.setBroken(true);
            this.logger.log(Level.SEVERE, "Component " + ((AbstractComponent)component).getInformation().friendlyName() + " failed to load!");
            t.printStackTrace();
            return false;
        }
    }

    public synchronized void enableComponents() {
        boolean changed;
        do {
            changed = false;
            for (ComponentRegistrationState<T> registrationState : this.registeredComponents) {
                if (registrationState.isEnabled() || registrationState.isBroken() || !this.hasDependenciesMet(registrationState) || !this.enableComponent(registrationState)) continue;
                changed = true;
            }
        } while (changed);
    }

    public synchronized void unloadComponents() {
        for (ComponentRegistrationState<T> registrationState : this.registeredComponents) {
            if (!registrationState.isEnabled()) continue;
            ((AbstractComponent)registrationState.getComponent()).disable();
        }
        this.registeredComponents.clear();
    }

    public synchronized void reloadComponents() {
        for (ComponentRegistrationState<T> registrationState : this.registeredComponents) {
            if (!registrationState.isEnabled()) continue;
            ((AbstractComponent)registrationState.getComponent()).reload();
        }
    }

    public synchronized <C> C getComponent(Class<C> type) {
        ComponentRegistrationState<T> result = this.registeredComponentsByClass.get(type);
        if (result == null) {
            return null;
        }
        return type.cast(result.getComponent());
    }

    public Collection<T> getComponents() {
        return this.registeredComponents.stream().map(ComponentRegistrationState::getComponent).collect(Collectors.toList());
    }

    public T getComponent(String friendlyName) {
        ComponentRegistrationState<T> result = this.registeredComponentsByName.get(this.standardizeName(friendlyName));
        if (result == null) {
            return null;
        }
        return result.getComponent();
    }

    public synchronized <A extends Annotation> void registerAnnotationHandler(Class<A> annotation, AnnotationHandler<A> handler) {
        this.annotationHandlers.put(annotation, handler);
    }

    public synchronized <A extends Annotation> AnnotationHandler<A> getAnnotationHandler(Class<A> annotation) {
        return this.annotationHandlers.get(annotation);
    }
}

