/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util.persistent;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.util.persistent.PersistentStorage;
import com.sk89q.util.yaml.YAMLFormat;
import com.sk89q.util.yaml.YAMLProcessor;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class YAMLPersistentStorage
extends PersistentStorage {
    private YAMLProcessor processor;

    @Override
    public void open() {
        CraftBookPlugin.logger().info("Loading persistent data from YAML!");
        File oldFile = new File(CraftBookPlugin.inst().getDataFolder(), "persistance.yml");
        if (oldFile.exists()) {
            oldFile.renameTo(new File(CraftBookPlugin.inst().getDataFolder(), "persistence.yml"));
            oldFile.delete();
        }
        File file = new File(CraftBookPlugin.inst().getDataFolder(), "persistence.yml");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.processor = new YAMLProcessor(file, true, YAMLFormat.COMPACT);
        try {
            this.processor.load();
        }
        catch (Throwable e) {
            CraftBookBukkitUtil.printStacktrace(e);
            CraftBookPlugin.logger().warning("Persistent Data Corrupt! Data will be reset!");
        }
        if (this.getVersion() != this.getCurrentVersion()) {
            CraftBookPlugin.logger().info("Converting database of type: " + this.getType() + " from version " + this.getVersion() + " to " + this.getCurrentVersion());
            this.convertVersion(this.getCurrentVersion());
            this.processor.clear();
            try {
                this.processor.load();
            }
            catch (Exception e) {
                CraftBookBukkitUtil.printStacktrace(e);
                CraftBookPlugin.logger().warning("Persistent Data Corrupt! Data will be reset!");
            }
        }
    }

    @Override
    public void close() {
        CraftBookPlugin.logger().info("Saving persistent data to YAML!");
        this.processor.save();
        this.processor.clear();
    }

    @Override
    public Object get(String location) {
        return this.processor.getProperty(location);
    }

    @Override
    public void set(String location, Object data) {
        this.processor.setProperty(location, data);
    }

    @Override
    public boolean has(String location) {
        return this.processor.getProperty(location) != null;
    }

    @Override
    public boolean isValid() {
        return this.processor != null;
    }

    @Override
    public String getType() {
        return "YAML";
    }

    @Override
    public int getVersion() {
        return this.processor.getInt("version", this.getCurrentVersion());
    }

    @Override
    public void convertVersion(int version) {
    }

    @Override
    public int getCurrentVersion() {
        return 1;
    }

    @Override
    public void importData(Map<String, Object> data, boolean replace) {
        if (replace) {
            this.processor.clear();
        }
        for (Map.Entry<String, Object> dat : data.entrySet()) {
            this.processor.setProperty(dat.getKey(), dat.getValue());
        }
    }

    @Override
    public Map<String, Object> exportData() {
        return this.processor.getMap();
    }
}

