/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util.jinglenote;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.jinglenote.Instrument;
import com.sk89q.craftbook.util.jinglenote.JingleNotePlayer;
import com.sk89q.craftbook.util.jinglenote.JingleSequencer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class StringJingleSequencer
implements JingleSequencer {
    private int delay;
    private int position;
    private int taskID;
    private boolean isPlaying;
    private boolean playedBefore = false;
    private List<JingleSequencer.Note> song;
    private Set<JingleNotePlayer> players = new HashSet<JingleNotePlayer>();

    public StringJingleSequencer(String tune, int delay) {
        this.delay = delay;
        this.song = StringJingleSequencer.parseTune(tune);
    }

    @Override
    public void run() throws InterruptedException {
        this.position = 0;
        if (this.song == null) {
            return;
        }
        this.isPlaying = true;
        this.playedBefore = true;
        this.taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)CraftBookPlugin.inst(), () -> {
            if (this.position >= this.song.size() || !this.isPlaying || this.players.isEmpty()) {
                Bukkit.getScheduler().cancelTask(this.taskID);
                this.isPlaying = false;
                return;
            }
            for (JingleNotePlayer player : this.players) {
                player.play(this.song.get(this.position));
            }
            ++this.position;
        }, (long)this.delay, (long)this.delay);
    }

    private static ArrayList<JingleSequencer.Note> parseTune(String tune) {
        if (tune == null) {
            return null;
        }
        ArrayList<JingleSequencer.Note> musicKeys = new ArrayList<JingleSequencer.Note>();
        byte instrument = -1;
        for (int i = 0; i < tune.length(); ++i) {
            int octave;
            char first = tune.charAt(i);
            if (first >= '0' && first <= '9') {
                instrument = StringJingleSequencer.getTypeFromChar(first);
                continue;
            }
            if (i + 1 >= tune.length()) continue;
            if (instrument == -1) {
                return null;
            }
            int pitch = StringJingleSequencer.getPitchFromChar(first);
            boolean skip = false;
            if (pitch == -1) {
                switch (first) {
                    case ' ': 
                    case '-': {
                        skip = true;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            try {
                octave = Integer.parseInt(Character.toString(tune.charAt(i + 1)));
            }
            catch (NumberFormatException e) {
                octave = 2;
            }
            if (skip) {
                musicKeys.add(new JingleSequencer.Note(Instrument.HARP, 0, 0.0f));
            } else {
                if (octave < 2) {
                    octave = 2;
                }
                if ((pitch += (octave - 2) * 12) < 0) {
                    pitch = 0;
                } else if (pitch > 24) {
                    pitch = 24;
                }
                musicKeys.add(new JingleSequencer.Note(Instrument.toMCSound(instrument), (byte)pitch, 60.0f));
            }
            ++i;
        }
        if (musicKeys.size() == 0) {
            return null;
        }
        return musicKeys;
    }

    private static byte getTypeFromChar(char type) {
        byte instrument = -1;
        switch (type) {
            case '0': 
            case '7': 
            case '8': 
            case '9': {
                instrument = 0;
                break;
            }
            case '1': {
                instrument = 1;
                break;
            }
            case '2': {
                instrument = 2;
                break;
            }
            case '3': {
                instrument = 3;
                break;
            }
            case '4': {
                instrument = 4;
                break;
            }
            case '5': {
                instrument = 5;
                break;
            }
            case '6': {
                instrument = 6;
            }
        }
        return instrument;
    }

    private static int getPitchFromChar(char charPitch) {
        int pitch = 0;
        switch (charPitch) {
            case 'f': {
                ++pitch;
            }
            case 'e': {
                ++pitch;
            }
            case 'D': {
                ++pitch;
            }
            case 'd': {
                ++pitch;
            }
            case 'C': {
                ++pitch;
            }
            case 'c': {
                ++pitch;
            }
            case 'b': {
                ++pitch;
            }
            case 'A': {
                ++pitch;
            }
            case 'a': {
                ++pitch;
            }
            case 'G': {
                ++pitch;
            }
            case 'g': {
                ++pitch;
            }
            case 'F': {
                break;
            }
            default: {
                pitch = -1;
            }
        }
        return pitch;
    }

    @Override
    public void stop() {
        this.isPlaying = false;
    }

    @Override
    public boolean isPlaying() {
        return this.isPlaying;
    }

    @Override
    public boolean hasPlayedBefore() {
        return this.playedBefore;
    }

    @Override
    public void stop(JingleNotePlayer player) {
        this.players.remove(player);
    }

    @Override
    public void play(JingleNotePlayer player) {
        this.players.add(player);
        if (!this.playedBefore) {
            try {
                this.run();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int getPlayerCount() {
        return this.players.size();
    }

    @Override
    public Set<JingleNotePlayer> getPlayers() {
        return this.players;
    }
}

