/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util.jinglenote;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.ICManager;
import com.sk89q.craftbook.util.SearchArea;
import com.sk89q.craftbook.util.jinglenote.JingleNoteManager;
import com.sk89q.craftbook.util.jinglenote.JingleSequencer;
import com.sk89q.craftbook.util.jinglenote.MidiJingleSequencer;
import com.sk89q.craftbook.util.jinglenote.StringJingleSequencer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiUnavailableException;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Playlist {
    private String playlist;
    private List<String> lines = new ArrayList<String>();
    private BukkitTask task;
    protected PlaylistInterpreter show = new PlaylistInterpreter();
    private boolean playing = false;

    public Playlist(String name) {
        this.playlist = name;
        try {
            this.readPlaylist();
        }
        catch (IOException e) {
            CraftBookBukkitUtil.printStacktrace(e);
        }
    }

    public PlaylistInterpreter getPlaylistInterpreter() {
        return this.show;
    }

    private void readPlaylist() throws IOException {
        String line;
        this.lines.clear();
        File file = new File(new File(ICManager.inst().getMidiFolder(), "playlists"), this.playlist + ".txt");
        if (!file.exists()) {
            CraftBookPlugin.logger().severe("Playlist File Not Found! " + file.getName());
            return;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        while ((line = br.readLine()) != null) {
            if (line.trim().isEmpty()) continue;
            this.lines.add(line);
        }
        br.close();
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void startPlaylist() {
        this.playing = true;
        if (this.task != null) {
            this.task.cancel();
        }
        this.show = new PlaylistInterpreter();
        this.task = Bukkit.getScheduler().runTaskAsynchronously((Plugin)CraftBookPlugin.inst(), (Runnable)this.show);
    }

    public void stopPlaylist() {
        this.show.lastPlayers.clear();
        this.show.jNote.stopAll();
        this.show.sequencer = null;
        this.show.players.clear();
        if (this.task != null) {
            this.task.cancel();
        }
        this.show.position = 0;
        this.playing = false;
    }

    public class PlaylistInterpreter
    implements Runnable {
        protected volatile int position = 0;
        volatile JingleNoteManager jNote = new JingleNoteManager();
        volatile JingleSequencer sequencer;
        protected volatile Map<String, SearchArea> players = new HashMap<String, SearchArea>();
        private volatile Map<String, SearchArea> lastPlayers = new HashMap<String, SearchArea>();

        PlaylistInterpreter() {
            CraftBookPlugin.logDebugMessage("Created new playlist interpreter!", "playlist");
        }

        public synchronized void setPlayers(Map<String, SearchArea> newPlayers) {
            this.lastPlayers = new HashMap<String, SearchArea>(this.players);
            this.players.clear();
            this.players.putAll(newPlayers);
            CraftBookPlugin.logDebugMessage("Reset player list!", "playlist");
        }

        public synchronized void addPlayers(Map<String, SearchArea> newPlayers) {
            this.lastPlayers = new HashMap<String, SearchArea>(this.players);
            this.players.putAll(newPlayers);
            CraftBookPlugin.logDebugMessage("Added player list!", "playlist");
        }

        public synchronized void removePlayers(Map<String, SearchArea> newPlayers) {
            this.lastPlayers = new HashMap<String, SearchArea>(this.players);
            for (String player : newPlayers.keySet()) {
                this.players.remove(player);
            }
            CraftBookPlugin.logDebugMessage("Subtracted from player list!", "playlist");
        }

        public Map<String, SearchArea> getPlayers() {
            return this.players;
        }

        @Override
        public void run() {
            while (this.position < Playlist.this.lines.size() && Playlist.this.isPlaying()) {
                if (this.sequencer != null) {
                    while (this.sequencer != null && this.sequencer.isPlaying() && this.sequencer.getPlayerCount() > 0) {
                        for (Map.Entry<String, SearchArea> p : this.lastPlayers.entrySet()) {
                            if (this.players.containsKey(p.getKey()) && this.jNote.isPlaying(p.getKey())) continue;
                            this.jNote.stop(p.getKey());
                            CraftBookPlugin.logDebugMessage("Removed player from sequencer: " + p.getKey(), "playlist");
                        }
                        for (Map.Entry<String, SearchArea> p : this.players.entrySet()) {
                            if (this.lastPlayers.containsKey(p.getKey())) continue;
                            this.jNote.play(p.getKey(), this.sequencer, p.getValue());
                            CraftBookPlugin.logDebugMessage("Added player to sequencer: " + p.getKey(), "playlist");
                        }
                        this.lastPlayers = new HashMap<String, SearchArea>(this.players);
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            CraftBookBukkitUtil.printStacktrace(e);
                        }
                        if (Playlist.this.isPlaying()) continue;
                        CraftBookPlugin.logDebugMessage("No longer playing! Stopping sequencer", "playlist");
                        this.sequencer.stop();
                        break;
                    }
                    this.sequencer = null;
                    CraftBookPlugin.logDebugMessage("Erasing sequencer", "playlist");
                }
                if (this.sequencer != null) continue;
                if (this.position >= Playlist.this.lines.size()) {
                    CraftBookPlugin.inst().getLogger().warning("Playlist: " + Playlist.this.playlist + " ended unexpectedly! Is your playlist file correct?");
                    break;
                }
                String line = (String)Playlist.this.lines.get(this.position);
                ++this.position;
                if (line.trim().startsWith("#") || line.trim().isEmpty()) continue;
                while (this.players.isEmpty()) {
                    if (!Playlist.this.isPlaying()) {
                        return;
                    }
                    CraftBookPlugin.logDebugMessage("Playlist has no players", "playlist");
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        CraftBookBukkitUtil.printStacktrace(e);
                    }
                }
                if (line.startsWith("wait ")) {
                    if (Playlist.this.isPlaying()) {
                        Playlist.this.task.cancel();
                        PlaylistInterpreter show = new PlaylistInterpreter();
                        show.position = this.position;
                        show.players = this.players;
                        show.lastPlayers = this.lastPlayers;
                        show.sequencer = this.sequencer;
                        show.jNote = this.jNote;
                        Playlist.this.task = Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)CraftBookPlugin.inst(), (Runnable)show, Long.parseLong(StringUtils.replace((String)line, (String)"wait ", (String)"")));
                    }
                    return;
                }
                if (line.startsWith("midi ")) {
                    File file = null;
                    String midiName = StringUtils.replace((String)line, (String)"midi ", (String)"");
                    File[] fileArray = new File[]{new File(ICManager.inst().getMidiFolder(), midiName), new File(ICManager.inst().getMidiFolder(), (String)midiName + ".mid"), new File(ICManager.inst().getMidiFolder(), (String)midiName + ".midi"), new File("midi", midiName), new File("midi", (String)midiName + ".mid"), new File("midi", (String)midiName + ".midi")};
                    for (File f : fileArray) {
                        if (!f.exists()) continue;
                        file = f;
                        break;
                    }
                    if (file == null) {
                        CraftBookPlugin.inst().getLogger().warning("Failed to find midi file: " + (String)midiName + " for playlist file: " + Playlist.this.playlist + ". Skipping midi!");
                        continue;
                    }
                    try {
                        this.sequencer = new MidiJingleSequencer(file, false);
                        if (!((MidiJingleSequencer)this.sequencer).getSequencer().isOpen()) {
                            ((MidiJingleSequencer)this.sequencer).getSequencer().open();
                        }
                        CraftBookPlugin.logDebugMessage("Player list on midi create: " + this.players.toString(), "playlist");
                        for (Map.Entry entry : this.players.entrySet()) {
                            this.jNote.play((String)entry.getKey(), this.sequencer, (SearchArea)entry.getValue());
                            CraftBookPlugin.logDebugMessage("Added player to midi sequencer upon creation: " + (String)entry.getKey(), "playlist");
                        }
                        this.lastPlayers = new HashMap<String, SearchArea>(this.players);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            CraftBookBukkitUtil.printStacktrace(e);
                        }
                    }
                    catch (IOException | InvalidMidiDataException | MidiUnavailableException e) {
                        CraftBookBukkitUtil.printStacktrace(e);
                    }
                    continue;
                }
                if (line.startsWith("tune ")) {
                    String tune = StringUtils.replace((String)line, (String)"tune ", (String)"");
                    this.sequencer = new StringJingleSequencer(tune, 0);
                    for (Map.Entry entry : this.players.entrySet()) {
                        this.jNote.play((String)entry.getKey(), this.sequencer, (SearchArea)entry.getValue());
                        CraftBookPlugin.logDebugMessage("Added player to string sequencer upon creation: " + (String)entry.getKey(), "playlist");
                    }
                    this.lastPlayers = new HashMap<String, SearchArea>(this.players);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        CraftBookBukkitUtil.printStacktrace(e);
                    }
                    continue;
                }
                if (line.startsWith("send ")) {
                    String message = StringUtils.replace((String)line, (String)"send ", (String)"");
                    for (String string : this.players.keySet()) {
                        Player pp = Bukkit.getPlayerExact((String)string);
                        if (pp == null) continue;
                        pp.sendMessage(message);
                    }
                    continue;
                }
                if (!line.startsWith("goto ")) continue;
                this.position = Integer.parseInt(StringUtils.replace((String)line, (String)"goto ", (String)""));
                CraftBookPlugin.logDebugMessage("Setting line to: " + this.position, "playlist");
            }
        }
    }
}

