/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util.compat.companion;

import com.comphenix.protocol.ProtocolLibrary;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class CompanionPlugins {
    private WorldEditPlugin worldEditPlugin;
    private Economy economy;
    private ProtocolLibrary protocolLib;
    private WorldGuardPlugin worldGuardPlugin;

    public void initiate(CraftBookPlugin plugin) {
        Plugin checkPlugin = plugin.getServer().getPluginManager().getPlugin("WorldEdit");
        if (checkPlugin != null && checkPlugin instanceof WorldEditPlugin) {
            this.worldEditPlugin = (WorldEditPlugin)checkPlugin;
        } else {
            try {
                String string = "worldedit:cui";
            }
            catch (Throwable t) {
                plugin.getLogger().severe("WorldEdit detection has failed!");
                plugin.getLogger().severe("WorldEdit is a required dependency, Craftbook disabled!");
                return;
            }
        }
        try {
            checkPlugin = plugin.getServer().getPluginManager().getPlugin("ProtocolLib");
            this.protocolLib = checkPlugin != null && checkPlugin instanceof ProtocolLibrary ? (ProtocolLibrary)checkPlugin : null;
        }
        catch (Throwable e) {
            this.protocolLib = null;
            plugin.getLogger().severe("You have a corrupt version of ProtocolLib! Please redownload it!");
            CraftBookBukkitUtil.printStacktrace(e);
        }
        checkPlugin = plugin.getServer().getPluginManager().getPlugin("WorldGuard");
        this.worldGuardPlugin = checkPlugin != null && checkPlugin instanceof WorldGuardPlugin ? (WorldGuardPlugin)checkPlugin : null;
        try {
            RegisteredServiceProvider economyProvider = plugin.getServer().getServicesManager().getRegistration(Economy.class);
            this.economy = economyProvider != null ? (Economy)economyProvider.getProvider() : null;
        }
        catch (Throwable e) {
            this.economy = null;
        }
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public boolean hasProtocolLib() {
        return this.protocolLib != null;
    }

    public ProtocolLibrary getProtocolLib() {
        return this.protocolLib;
    }

    public WorldEditPlugin getWorldEdit() {
        return this.worldEditPlugin;
    }

    public WorldGuardPlugin getWorldGuard() {
        return this.worldGuardPlugin;
    }
}

