/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util.compat;

import com.sk89q.craftbook.util.compat.CraftBookCompatability;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

public class NoCheatPlusCompatability
implements CraftBookCompatability {
    private Map<String, EnumSet<CheckType>> disabledChecks = new HashMap<String, EnumSet<CheckType>>();
    private CheckType[] toDisable = new CheckType[]{CheckType.BLOCKBREAK, CheckType.BLOCKINTERACT, CheckType.COMBINED, CheckType.MOVING, CheckType.BLOCKPLACE};

    @Override
    public void enable(Player player) {
        EnumSet<CheckType> dis = this.disabledChecks.containsKey(player.getName()) ? this.disabledChecks.get(player.getName()) : EnumSet.noneOf(CheckType.class);
        for (CheckType to : this.toDisable) {
            if (NCPExemptionManager.isExempted((Player)player, (CheckType)to)) continue;
            NCPExemptionManager.exemptPermanently((Player)player, (CheckType)to);
            dis.add(to);
        }
        if (dis.size() > 0) {
            this.disabledChecks.put(player.getName(), dis);
        }
    }

    @Override
    public void disable(Player player) {
        if (this.disabledChecks.containsKey(player.getName())) {
            for (CheckType type : this.disabledChecks.get(player.getName())) {
                NCPExemptionManager.unexempt((Player)player, (CheckType)type);
            }
            this.disabledChecks.remove(player.getName());
        }
    }
}

