/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.ICMechanic;
import com.sk89q.craftbook.util.EntityType;
import com.sk89q.craftbook.util.ICUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public final class SearchArea {
    private Location center = null;
    private Vector3 radius = null;
    private BlockVector3 blockRadius = null;
    private ProtectedRegion region = null;
    private World world = null;

    private SearchArea() {
    }

    private SearchArea(Location center, Vector3 radius) {
        this.center = center;
        this.radius = radius;
        this.blockRadius = radius.toBlockPoint();
    }

    private SearchArea(ProtectedRegion region, World world) {
        this.region = region;
        this.world = world;
    }

    public static SearchArea createEmptyArea() {
        return new SearchArea();
    }

    public static SearchArea createArea(Block block, String line) {
        if (line.startsWith("r:")) {
            if (CraftBookPlugin.plugins.getWorldGuard() == null) {
                return new SearchArea();
            }
            ProtectedRegion reg = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)block.getWorld())).getRegion(StringUtils.replace((String)line, (String)"r:", (String)""));
            if (reg == null) {
                return new SearchArea();
            }
            return new SearchArea(reg, block.getWorld());
        }
        String[] locationParts = RegexUtil.EQUALS_PATTERN.split(line);
        Location offset = SignUtil.getBackBlock(block).getLocation();
        Vector3 radius = ICUtil.parseRadius(locationParts[0]);
        if (locationParts.length > 1) {
            offset = ICUtil.parseBlockLocation(CraftBookBukkitUtil.toChangedSign(block), locationParts[1], ICMechanic.instance.defaultCoordinates).getLocation();
        }
        return new SearchArea(offset, radius);
    }

    public static boolean isValidArea(Block block, String line) {
        if (line.startsWith("r:")) {
            if (CraftBookPlugin.plugins.getWorldGuard() == null) {
                return false;
            }
            ProtectedRegion reg = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)block.getWorld())).getRegion(StringUtils.replace((String)line, (String)"r:", (String)""));
            return reg != null;
        }
        String[] locationParts = RegexUtil.EQUALS_PATTERN.split(line);
        SignUtil.getBackBlock(block).getLocation();
        try {
            ICUtil.parseUnsafeRadius(locationParts[0]);
            if (locationParts.length > 1) {
                ICUtil.parseUnsafeBlockLocation(locationParts[1]);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<Player> getPlayersInArea() {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.isWithinArea(player.getLocation())) continue;
            players.add(player);
        }
        return players;
    }

    public List<Entity> getEntitiesInArea(Collection<EntityType> types) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Chunk chunk : this.getChunksInArea()) {
            for (Entity ent : chunk.getEntities()) {
                if (!ent.isValid() || !this.isWithinArea(ent.getLocation())) continue;
                boolean isType = false;
                for (EntityType type : types) {
                    if (!type.is(ent)) continue;
                    isType = true;
                    break;
                }
                if (!isType) continue;
                entities.add(ent);
            }
        }
        return entities;
    }

    public List<Entity> getEntitiesInArea() {
        return this.getEntitiesInArea(Collections.singletonList(EntityType.ANY));
    }

    public boolean isWithinArea(Location location) {
        if (this.hasRegion()) {
            if (!this.region.isPhysicalArea() || this.region.contains(CraftBookBukkitUtil.toVector(location.getBlock())) && location.getWorld().equals(this.world)) {
                return true;
            }
        } else if (this.hasRadiusAndCenter()) {
            if (LocationUtil.isWithinRadius(location, this.center, this.radius)) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public Set<Chunk> getChunksInArea() {
        HashSet<Chunk> chunks;
        block5: {
            block4: {
                chunks = new HashSet<Chunk>();
                if (!this.hasRegion()) break block4;
                Chunk c1 = this.getWorld().getChunkAt(this.region.getMinimumPoint().getBlockX() >> 4, this.region.getMinimumPoint().getBlockZ() >> 4);
                Chunk c2 = this.getWorld().getChunkAt(this.region.getMaximumPoint().getBlockX() >> 4, this.region.getMaximumPoint().getBlockZ() >> 4);
                int xMin = Math.min(c1.getX(), c2.getX());
                int xMax = Math.max(c1.getX(), c2.getX());
                int zMin = Math.min(c1.getZ(), c2.getZ());
                int zMax = Math.max(c1.getZ(), c2.getZ());
                for (int x = xMin; x <= xMax; ++x) {
                    for (int z = zMin; z <= zMax; ++z) {
                        chunks.add(this.getWorld().getChunkAt(x, z));
                    }
                }
                break block5;
            }
            if (!this.hasRadiusAndCenter()) break block5;
            int chunkRadiusX = this.blockRadius.getBlockX() < 16 ? 1 : this.blockRadius.getBlockX() / 16;
            int chunkRadiusZ = this.blockRadius.getBlockZ() < 16 ? 1 : this.blockRadius.getBlockZ() / 16;
            for (int chX = 0 - chunkRadiusX; chX <= chunkRadiusX; ++chX) {
                for (int chZ = 0 - chunkRadiusZ; chZ <= chunkRadiusZ; ++chZ) {
                    chunks.add(new Location(this.center.getWorld(), (double)(this.center.getBlockX() + chX * 16), (double)this.center.getBlockY(), (double)(this.center.getBlockZ() + chZ * 16)).getChunk());
                }
            }
        }
        return chunks;
    }

    public Block getRandomBlockInArea() {
        int zMax;
        int zMin;
        int yMax;
        int yMin;
        int xMax;
        int xMin;
        if (this.hasRegion()) {
            xMin = this.region.getMinimumPoint().getBlockX();
            xMax = this.region.getMaximumPoint().getBlockX();
            yMin = this.region.getMinimumPoint().getBlockY();
            yMax = this.region.getMaximumPoint().getBlockY();
            zMin = this.region.getMinimumPoint().getBlockZ();
            zMax = this.region.getMaximumPoint().getBlockZ();
        } else if (this.hasRadiusAndCenter()) {
            xMin = Math.min(this.center.getBlockX() - this.blockRadius.getBlockX(), this.center.getBlockX() + this.blockRadius.getBlockX());
            xMax = Math.max(this.center.getBlockX() - this.blockRadius.getBlockX(), this.center.getBlockX() + this.blockRadius.getBlockX());
            yMin = Math.min(this.center.getBlockY() - this.blockRadius.getBlockY(), this.center.getBlockY() + this.blockRadius.getBlockY());
            yMax = Math.max(this.center.getBlockY() - this.blockRadius.getBlockY(), this.center.getBlockY() + this.blockRadius.getBlockY());
            zMin = Math.min(this.center.getBlockZ() - this.blockRadius.getBlockZ(), this.center.getBlockZ() + this.blockRadius.getBlockZ());
            zMax = Math.max(this.center.getBlockZ() - this.blockRadius.getBlockZ(), this.center.getBlockZ() + this.blockRadius.getBlockZ());
        } else {
            return null;
        }
        int x = xMin + CraftBookPlugin.inst().getRandom().nextInt(xMax - xMin + 1);
        int y = yMin + CraftBookPlugin.inst().getRandom().nextInt(yMax - yMin + 1);
        int z = zMin + CraftBookPlugin.inst().getRandom().nextInt(zMax - zMin + 1);
        Location loc = new Location(this.getWorld(), (double)x, (double)y, (double)z);
        if (!this.isWithinArea(loc)) {
            return null;
        }
        return loc.getBlock();
    }

    public boolean hasRegion() {
        return this.region != null && this.world != null && CraftBookPlugin.plugins.getWorldGuard() != null;
    }

    public boolean hasRadiusAndCenter() {
        return this.radius != null && this.center != null;
    }

    public Location getCenter() {
        return this.center;
    }

    public Vector3 getRadius() {
        return this.radius;
    }

    public ProtectedRegion getRegion() {
        return this.region;
    }

    public World getWorld() {
        if (this.world == null && this.center != null) {
            return this.center.getWorld();
        }
        return this.world;
    }

    public boolean isValid() {
        return this.hasRadiusAndCenter() || this.hasRegion();
    }
}

