/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.CompatabilityUtil;
import com.sk89q.craftbook.util.EventUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public final class ProtectionUtil {
    public static boolean canBuild(Player player, Location loc, boolean build) {
        return ProtectionUtil.canBuild(player, loc.getBlock(), build);
    }

    public static boolean canBuild(Player player, Block block, boolean build) {
        if (!ProtectionUtil.shouldUseProtection()) {
            return true;
        }
        if (CraftBookPlugin.inst().getConfiguration().advancedBlockChecks) {
            CompatabilityUtil.disableInterferences(player);
            Object event = build ? new BlockPlaceEvent(block, block.getState(), block.getRelative(0, -1, 0), player.getInventory().getItemInMainHand(), player, true, EquipmentSlot.HAND) : new BlockBreakEvent(block, player);
            EventUtil.ignoreEvent((Event)event);
            CraftBookPlugin.inst().getServer().getPluginManager().callEvent((Event)event);
            CompatabilityUtil.enableInterferences(player);
            return !((Cancellable)event).isCancelled() && (!(event instanceof BlockPlaceEvent) || ((BlockPlaceEvent)event).canBuild());
        }
        return !CraftBookPlugin.inst().getConfiguration().obeyWorldguard || (CraftBookPlugin.plugins.getWorldGuard() == null || build ? CraftBookPlugin.plugins.getWorldGuard().createProtectionQuery().testBlockPlace((Object)player, block.getLocation(), block.getType()) : CraftBookPlugin.plugins.getWorldGuard().createProtectionQuery().testBlockBreak((Object)player, block));
    }

    public static boolean canSendCommand(Player player, String command) {
        if (!ProtectionUtil.shouldUseProtection()) {
            return true;
        }
        if (CraftBookPlugin.inst().getConfiguration().advancedBlockChecks) {
            CompatabilityUtil.disableInterferences(player);
            PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent(player, command);
            EventUtil.ignoreEvent((Event)event);
            CraftBookPlugin.inst().getServer().getPluginManager().callEvent((Event)event);
            CompatabilityUtil.enableInterferences(player);
            return !event.isCancelled();
        }
        return true;
    }

    public static boolean canUse(Player player, Location loc, BlockFace face, Action action) {
        if (!ProtectionUtil.shouldUseProtection()) {
            return true;
        }
        if (CraftBookPlugin.inst().getConfiguration().advancedBlockChecks) {
            CompatabilityUtil.disableInterferences(player);
            PlayerInteractEvent event = new PlayerInteractEvent(player, action == null ? Action.RIGHT_CLICK_BLOCK : action, player.getItemInHand(), loc.getBlock(), face == null ? BlockFace.SELF : face);
            EventUtil.ignoreEvent((Event)event);
            CraftBookPlugin.inst().getServer().getPluginManager().callEvent((Event)event);
            CompatabilityUtil.enableInterferences(player);
            if (!event.isCancelled() && CraftBookPlugin.inst().getConfiguration().obeyWorldguard && CraftBookPlugin.plugins.getWorldGuard() != null) {
                return CraftBookPlugin.plugins.getWorldGuard().createProtectionQuery().testBlockInteract((Object)player, loc.getBlock());
            }
            return !event.isCancelled();
        }
        return !CraftBookPlugin.inst().getConfiguration().obeyWorldguard || CraftBookPlugin.plugins.getWorldGuard() == null || CraftBookPlugin.plugins.getWorldGuard().createProtectionQuery().testBlockInteract((Object)player, loc.getBlock());
    }

    public static boolean canAccessInventory(Player player, Block block) {
        if (!ProtectionUtil.shouldUseProtection()) {
            return true;
        }
        if (CraftBookPlugin.inst().getConfiguration().advancedBlockChecks && !ProtectionUtil.canUse(player, block.getLocation(), null, Action.RIGHT_CLICK_BLOCK)) {
            return false;
        }
        return !CraftBookPlugin.inst().getConfiguration().obeyWorldguard || CraftBookPlugin.plugins.getWorldGuard() == null || CraftBookPlugin.plugins.getWorldGuard().createProtectionQuery().testBlockInteract((Object)player, block);
    }

    public static boolean canBlockForm(Block block, BlockState newState) {
        if (!ProtectionUtil.shouldUseProtection()) {
            return true;
        }
        if (CraftBookPlugin.inst().getConfiguration().advancedBlockChecks) {
            BlockFormEvent event = new BlockFormEvent(block, newState);
            EventUtil.ignoreEvent((Event)event);
            CraftBookPlugin.inst().getServer().getPluginManager().callEvent((Event)event);
            return !event.isCancelled();
        }
        return !CraftBookPlugin.inst().getConfiguration().obeyWorldguard || CraftBookPlugin.plugins.getWorldGuard() == null || newState.getType() != Material.SNOW && newState.getType() != Material.ICE || CraftBookPlugin.plugins.getWorldGuard().createProtectionQuery().testBlockPlace(null, block.getLocation(), newState.getType());
    }

    public static boolean shouldUseProtection() {
        return CraftBookPlugin.inst().getConfiguration().advancedBlockChecks || CraftBookPlugin.inst().getConfiguration().obeyWorldguard;
    }
}

