/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public enum PlayerType {
    NAME('p'),
    UUID('u'),
    CBID('i'),
    GROUP('g'),
    PERMISSION_NODE('n'),
    TEAM('t'),
    ALL('a');

    char prefix;

    private PlayerType(char prefix) {
        this.prefix = prefix;
    }

    public static PlayerType getFromChar(char c) {
        c = Character.toLowerCase(c);
        for (PlayerType t : PlayerType.values()) {
            if (t.prefix != c) continue;
            return t;
        }
        return NAME;
    }

    public boolean doesPlayerPass(Player player, String line) {
        switch (this) {
            case GROUP: {
                return CraftBookPlugin.inst().inGroup(player, line);
            }
            case CBID: {
                return CraftBookPlugin.inst().getUUIDMappings().getCBID(player.getUniqueId()).equals(line);
            }
            case NAME: {
                return player.getName().toLowerCase(Locale.ENGLISH).startsWith(line.toLowerCase(Locale.ENGLISH));
            }
            case UUID: {
                return player.getUniqueId().toString().toUpperCase(Locale.ENGLISH).startsWith(line.toUpperCase(Locale.ENGLISH));
            }
            case PERMISSION_NODE: {
                return player.hasPermission(line);
            }
            case TEAM: {
                try {
                    return Bukkit.getScoreboardManager().getMainScoreboard().getTeam(line).hasEntry(player.getName());
                }
                catch (Exception exception) {
                    break;
                }
            }
            case ALL: {
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }
}

