/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.math.Vector3;
import java.util.HashSet;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public final class LocationUtil {
    public static boolean isWithinSphericalRadius(Location l1, Location l2, double radius) {
        return l1.getWorld().equals(l2.getWorld()) && Math.floor(LocationUtil.getDistanceSquared(l1, l2)) <= radius * radius;
    }

    public static boolean isWithinRadiusPolygon(Location l1, Location l2, Vector3 radius) {
        if (!l1.getWorld().equals(l2.getWorld())) {
            return false;
        }
        return l2.getX() < l1.getX() + radius.getX() && l2.getX() > l1.getX() - radius.getX() && l2.getY() < l1.getY() + radius.getY() && l2.getY() > l1.getY() - radius.getY() && l2.getZ() < l1.getZ() + radius.getZ() && l2.getZ() > l1.getZ() - radius.getX();
    }

    public static boolean isWithinRadius(Location l1, Location l2, Vector3 radius) {
        return radius.getX() == radius.getZ() && radius.getX() == radius.getY() && LocationUtil.isWithinSphericalRadius(l1, l2, radius.getX()) || (radius.getX() != radius.getY() || radius.getY() != radius.getZ() || radius.getX() != radius.getZ()) && LocationUtil.isWithinRadiusPolygon(l1, l2, radius);
    }

    public static Entity[] getNearbyEntities(Location l, Vector3 radius) {
        int chunkRadiusX = (int)radius.getX() < 16 ? 1 : (int)radius.getX() / 16;
        int chunkRadiusZ = (int)radius.getZ() < 16 ? 1 : (int)radius.getZ() / 16;
        HashSet<Entity> radiusEntities = new HashSet<Entity>();
        for (int chX = 0 - chunkRadiusX; chX <= chunkRadiusX; ++chX) {
            for (int chZ = 0 - chunkRadiusZ; chZ <= chunkRadiusZ; ++chZ) {
                int offChunkX = l.getChunk().getX() + chX;
                int offChunkZ = l.getChunk().getZ() + chZ;
                if (!l.getWorld().isChunkLoaded(offChunkX, offChunkZ)) continue;
                for (Entity e : l.getWorld().getChunkAt(offChunkX, offChunkZ).getEntities()) {
                    if (e == null || e.isDead() || !e.isValid() || !LocationUtil.isWithinRadius(l, e.getLocation(), radius)) continue;
                    radiusEntities.add(e);
                }
            }
        }
        return radiusEntities.toArray(new Entity[radiusEntities.size()]);
    }

    public static double getDistance(Location l1, Location l2) {
        return Math.sqrt(LocationUtil.getDistanceSquared(l1, l2));
    }

    public static double getDistanceSquared(Location l1, Location l2) {
        if (!l1.getWorld().equals(l2.getWorld())) {
            return 2.147483647E9;
        }
        if (CraftBookPlugin.inst().getConfiguration().useBlockDistance) {
            return LocationUtil.getBlockDistance(l1, l2) * LocationUtil.getBlockDistance(l1, l2);
        }
        return l1.distanceSquared(l2);
    }

    public static int getBlockDistance(Location l1, Location l2) {
        if (!l1.getWorld().equals(l2.getWorld())) {
            return Integer.MAX_VALUE;
        }
        int x = Math.abs(l1.getBlockX() - l2.getBlockX());
        int y = Math.abs(l1.getBlockY() - l2.getBlockY());
        int z = Math.abs(l1.getBlockZ() - l2.getBlockZ());
        if (x >= y && x >= z) {
            return x;
        }
        if (y >= z) {
            return y;
        }
        return z;
    }

    public static Block getOffset(Block block, int offsetX, int offsetY, int offsetZ) {
        return block.getWorld().getBlockAt(block.getX() + offsetX, block.getY() + offsetY, block.getZ() + offsetZ);
    }

    public static Block getRelativeOffset(ChangedSign sign, int offsetX, int offsetY, int offsetZ) {
        return LocationUtil.getRelativeOffset(SignUtil.getBackBlock(CraftBookBukkitUtil.toSign(sign).getBlock()), SignUtil.getFacing(CraftBookBukkitUtil.toSign(sign).getBlock()), offsetX, offsetY, offsetZ);
    }

    public static Block getRelativeOffset(Block block, BlockFace front, int offsetX, int offsetY, int offsetZ) {
        BlockFace right;
        BlockFace left;
        BlockFace back;
        switch (front) {
            case SOUTH: {
                back = BlockFace.NORTH;
                left = BlockFace.EAST;
                right = BlockFace.WEST;
                break;
            }
            case WEST: {
                back = BlockFace.EAST;
                left = BlockFace.SOUTH;
                right = BlockFace.NORTH;
                break;
            }
            case NORTH: {
                back = BlockFace.SOUTH;
                left = BlockFace.WEST;
                right = BlockFace.EAST;
                break;
            }
            case EAST: {
                back = BlockFace.WEST;
                left = BlockFace.NORTH;
                right = BlockFace.SOUTH;
                break;
            }
            default: {
                back = BlockFace.SOUTH;
                left = BlockFace.EAST;
                right = BlockFace.WEST;
            }
        }
        if (offsetX > 0) {
            block = LocationUtil.getRelativeBlock(block, right, offsetX);
        } else if (offsetX < 0) {
            block = LocationUtil.getRelativeBlock(block, left, offsetX);
        }
        if (offsetZ > 0) {
            block = LocationUtil.getRelativeBlock(block, front, offsetZ);
        } else if (offsetZ < 0) {
            block = LocationUtil.getRelativeBlock(block, back, offsetZ);
        }
        if (offsetY > 0) {
            block = LocationUtil.getRelativeBlock(block, BlockFace.UP, offsetY);
        } else if (offsetY < 0) {
            block = LocationUtil.getRelativeBlock(block, BlockFace.DOWN, offsetY);
        }
        return block;
    }

    private static Block getRelativeBlock(Block block, BlockFace facing, int amount) {
        amount = Math.abs(amount);
        for (int i = 0; i < amount; ++i) {
            block = block.getRelative(facing);
        }
        return block;
    }

    public static Block getNextFreeSpace(Block block, BlockFace direction) {
        while (block.getType() != Material.AIR && block.getRelative(direction).getType() != Material.AIR && block.getY() < block.getWorld().getMaxHeight()) {
            block = block.getRelative(direction);
        }
        return block;
    }

    public static Location getCenterOfBlock(Block block) {
        return block.getLocation().add(0.5, 1.0, 0.5);
    }

    public static Player[] getNearbyPlayers(Location l, int radius) {
        int chunkRadius = radius < 16 ? 1 : radius / 16;
        HashSet<Player> radiusEntities = new HashSet<Player>();
        for (int chX = 0 - chunkRadius; chX <= chunkRadius; ++chX) {
            for (int chZ = 0 - chunkRadius; chZ <= chunkRadius; ++chZ) {
                int x = (int)l.getX();
                int y = (int)l.getY();
                int z = (int)l.getZ();
                for (Entity e : new Location(l.getWorld(), (double)(x + chX * 16), (double)y, (double)(z + chZ * 16)).getChunk().getEntities()) {
                    if (!(e instanceof Player) || !(LocationUtil.getDistanceSquared(e.getLocation(), l) <= (double)(radius * radius)) || e.getLocation().getBlock() == l.getBlock()) continue;
                    radiusEntities.add((Player)e);
                }
            }
        }
        return radiusEntities.toArray(new Player[radiusEntities.size()]);
    }

    public static boolean isBorderChunk(Chunk chunk) {
        World world = chunk.getWorld();
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                if (x == 0 && z == 0 || world.isChunkLoaded(chunk.getX() + x, chunk.getZ() + z)) continue;
                return true;
            }
        }
        return false;
    }

    public static BlockFace[] getDirectFaces() {
        return new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
    }

    public static BlockFace[] getIndirectFaces() {
        return new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH_EAST, BlockFace.NORTH_WEST, BlockFace.SOUTH_EAST, BlockFace.SOUTH_WEST};
    }
}

