/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util;

import com.sk89q.craftbook.util.ItemUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.block.BrewingStand;
import org.bukkit.block.Chest;
import org.bukkit.block.Furnace;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Player;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class InventoryUtil {
    public static List<ItemStack> addItemsToInventory(InventoryHolder container, ItemStack ... stacks) {
        return InventoryUtil.addItemsToInventory(container, true, stacks);
    }

    public static List<ItemStack> addItemsToInventory(InventoryHolder container, boolean update, ItemStack ... stacks) {
        if (container instanceof Furnace) {
            return InventoryUtil.addItemsToFurnace((Furnace)container, stacks);
        }
        if (container instanceof BrewingStand) {
            return InventoryUtil.addItemsToBrewingStand((BrewingStand)container, stacks);
        }
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        if (container instanceof ShulkerBox) {
            Arrays.stream(stacks).filter(item -> ItemUtil.isShulkerBox(item.getType())).forEach(leftovers::add);
            stacks = (ItemStack[])Arrays.stream(stacks).filter(item -> !ItemUtil.isShulkerBox(item.getType())).toArray(ItemStack[]::new);
        }
        leftovers.addAll(container.getInventory().addItem(stacks).values());
        if (container.getInventory() instanceof DoubleChestInventory) {
            ((Chest)((DoubleChestInventory)container.getInventory()).getLeftSide().getHolder()).update(true);
            ((Chest)((DoubleChestInventory)container.getInventory()).getRightSide().getHolder()).update(true);
        }
        return leftovers;
    }

    public static List<ItemStack> addItemsToFurnace(Furnace furnace, ItemStack ... stacks) {
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (!ItemUtil.isStackValid(stack)) continue;
            if (ItemUtil.isFurnacable(stack) && InventoryUtil.fitsInSlot(stack, furnace.getInventory().getSmelting())) {
                if (furnace.getInventory().getSmelting() == null) {
                    furnace.getInventory().setSmelting(stack);
                    continue;
                }
                leftovers.add(ItemUtil.addToStack(furnace.getInventory().getSmelting(), stack));
                continue;
            }
            if (ItemUtil.isAFuel(stack) && InventoryUtil.fitsInSlot(stack, furnace.getInventory().getFuel())) {
                if (furnace.getInventory().getFuel() == null) {
                    furnace.getInventory().setFuel(stack);
                    continue;
                }
                leftovers.add(ItemUtil.addToStack(furnace.getInventory().getFuel(), stack));
                continue;
            }
            leftovers.add(stack);
        }
        leftovers.removeAll(Collections.singleton(null));
        return leftovers;
    }

    public static List<ItemStack> addItemsToBrewingStand(BrewingStand brewingStand, ItemStack ... stacks) {
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (!ItemUtil.isAPotionIngredient(stack)) {
                leftovers.add(stack);
                continue;
            }
            BrewerInventory inv = brewingStand.getInventory();
            if (InventoryUtil.fitsInSlot(stack, inv.getIngredient())) {
                if (inv.getIngredient() == null) {
                    inv.setIngredient(stack);
                    continue;
                }
                leftovers.add(ItemUtil.addToStack(inv.getIngredient(), stack));
                continue;
            }
            leftovers.add(stack);
        }
        return leftovers;
    }

    public static boolean doesInventoryContain(Inventory inv, boolean exact, ItemStack ... stacks) {
        return InventoryUtil.doesInventoryContain(inv, !exact, false, false, false, stacks);
    }

    public static boolean doesInventoryContain(Inventory inv, boolean ignoreStackSize, boolean ignoreDurability, boolean ignoreMeta, boolean ignoreEnchants, ItemStack ... stacks) {
        ArrayList<ItemStack> itemsToFind = new ArrayList<ItemStack>(Arrays.asList(stacks));
        if (itemsToFind.isEmpty()) {
            return true;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(Arrays.asList(inv.getContents()));
        if (inv instanceof PlayerInventory) {
            items.addAll(Arrays.asList(((PlayerInventory)inv).getArmorContents()));
            items.add(((PlayerInventory)inv).getItemInOffHand());
        }
        block0: for (ItemStack item : items) {
            if (!ItemUtil.isStackValid(item)) continue;
            for (ItemStack base : stacks) {
                if (!itemsToFind.contains(base)) continue;
                if (!ItemUtil.isStackValid(base)) {
                    itemsToFind.remove(base);
                    continue;
                }
                if (!ItemUtil.areItemsSimilar(base, item) || !ignoreStackSize && base.getAmount() != item.getAmount() || !ignoreDurability && (base.getType().getMaxDurability() > 0 || item.getType().getMaxDurability() > 0) && base.getDurability() != item.getDurability() || !ignoreMeta && (base.hasItemMeta() != item.hasItemMeta() ? !ignoreEnchants || base.hasItemMeta() && ItemUtil.hasDisplayNameOrLore(base) || item.hasItemMeta() && ItemUtil.hasDisplayNameOrLore(item) : base.hasItemMeta() && base.hasItemMeta() && !ItemUtil.areItemMetaIdentical(base.getItemMeta(), item.getItemMeta(), !ignoreEnchants))) continue;
                itemsToFind.remove(base);
                continue block0;
            }
        }
        return itemsToFind.isEmpty();
    }

    public static boolean removeItemsFromInventory(InventoryHolder inv, ItemStack ... stacks) {
        ArrayList leftovers = new ArrayList(inv.getInventory().removeItem(stacks).values());
        if (!leftovers.isEmpty()) {
            ArrayList<ItemStack> itemsToAdd = new ArrayList<ItemStack>(Arrays.asList(stacks));
            itemsToAdd.removeAll(leftovers);
            inv.getInventory().addItem(itemsToAdd.toArray(new ItemStack[itemsToAdd.size()]));
        }
        return leftovers.isEmpty();
    }

    public static boolean fitsInSlot(ItemStack stack, ItemStack slot) {
        return slot == null || ItemUtil.areItemsIdentical(stack, slot) && stack.getAmount() + slot.getAmount() <= stack.getMaxStackSize();
    }

    public static boolean doesBlockHaveInventory(Block block) {
        switch (block.getType()) {
            case CHEST: 
            case TRAPPED_CHEST: 
            case DROPPER: 
            case DISPENSER: 
            case FURNACE: 
            case BREWING_STAND: 
            case HOPPER: 
            case WHITE_SHULKER_BOX: 
            case ORANGE_SHULKER_BOX: 
            case MAGENTA_SHULKER_BOX: 
            case LIGHT_BLUE_SHULKER_BOX: 
            case YELLOW_SHULKER_BOX: 
            case GREEN_SHULKER_BOX: 
            case PINK_SHULKER_BOX: 
            case GRAY_SHULKER_BOX: 
            case LIGHT_GRAY_SHULKER_BOX: 
            case BLUE_SHULKER_BOX: 
            case PURPLE_SHULKER_BOX: 
            case CYAN_SHULKER_BOX: 
            case BROWN_SHULKER_BOX: 
            case LIME_SHULKER_BOX: 
            case BLACK_SHULKER_BOX: 
            case RED_SHULKER_BOX: 
            case SHULKER_BOX: {
                return true;
            }
        }
        return false;
    }

    public static ItemStack getItemInHand(Player player, EquipmentSlot slot) {
        if (slot == EquipmentSlot.HAND) {
            return player.getInventory().getItemInMainHand();
        }
        if (slot == EquipmentSlot.OFF_HAND) {
            return player.getInventory().getItemInOffHand();
        }
        return null;
    }

    public static void setItemInHand(Player player, EquipmentSlot slot, ItemStack itemStack) {
        if (slot == EquipmentSlot.HAND) {
            player.getInventory().setItemInMainHand(itemStack);
        } else if (slot == EquipmentSlot.OFF_HAND) {
            player.getInventory().setItemInOffHand(itemStack);
        }
    }
}

