/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util;

import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Slime;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;

public final class EntityUtil {
    public static boolean isEntityInBlock(Entity entity, Block block) {
        Location entLoc = entity.getLocation().getBlock().getLocation();
        int heightOffset = 0;
        if (entity instanceof LivingEntity) {
            heightOffset = (int)Math.floor(((LivingEntity)entity).getEyeHeight());
        }
        while (heightOffset >= 0) {
            if (entLoc.getBlockX() == block.getLocation().getBlockX() && entLoc.getBlockY() + heightOffset == block.getLocation().getBlockY() && entLoc.getBlockZ() == block.getLocation().getBlockZ()) {
                return true;
            }
            --heightOffset;
        }
        return false;
    }

    public static boolean isEntityOfTypeInBlock(Block block, EntityType type) {
        for (Entity ent : block.getChunk().getEntities()) {
            if (ent.getType() != type || !EntityUtil.isEntityInBlock(ent, block)) continue;
            return true;
        }
        return false;
    }

    public static void killEntity(Entity ent) {
        if (ent instanceof Damageable) {
            ((Damageable)ent).damage(((Damageable)ent).getHealth());
        } else {
            ent.remove();
        }
    }

    public static void damageEntity(Entity ent, double damage) {
        if (ent instanceof Damageable) {
            ((Damageable)ent).damage(damage);
        } else if (ent instanceof Minecart) {
            ((Minecart)ent).setDamage(((Minecart)ent).getDamage() + damage);
        } else {
            ent.remove();
        }
    }

    public static EntityType[] parseEntityList(List<String> list) {
        ArrayList<EntityType> ents = new ArrayList<EntityType>();
        for (String s : list) {
            ents.add(EntityType.fromName((String)s));
        }
        return ents.toArray(new EntityType[ents.size()]);
    }

    public static void setEntityData(Entity ent, String bit) {
        String[] data = RegexUtil.COLON_PATTERN.split(bit);
        if (ent instanceof Ageable && data[0].equalsIgnoreCase("baby")) {
            ((Ageable)ent).setBaby();
        }
        if (ent instanceof Tameable && data[0].equalsIgnoreCase("tame")) {
            ((Tameable)ent).setTamed(true);
        }
        if (ent instanceof LivingEntity && data[0].equalsIgnoreCase("stay")) {
            ((LivingEntity)ent).setRemoveWhenFarAway(false);
        }
        if (ent instanceof LivingEntity && data[0].equalsIgnoreCase("despawn")) {
            ((LivingEntity)ent).setRemoveWhenFarAway(true);
        }
        if (ent instanceof LivingEntity && data[0].equalsIgnoreCase("pickup")) {
            ((LivingEntity)ent).setCanPickupItems(true);
        }
        if (ent instanceof Tameable && data[0].equalsIgnoreCase("owner")) {
            ((Tameable)ent).setOwner((AnimalTamer)Bukkit.getPlayer((String)data[1]));
        }
        if (ent instanceof LivingEntity && data[0].equalsIgnoreCase("name")) {
            ent.setCustomName(data[1]);
            ent.setCustomNameVisible(true);
        }
        if (ent instanceof Ageable && data[0].equalsIgnoreCase("babylock")) {
            ((Ageable)ent).setBaby();
            ((Ageable)ent).setAgeLock(true);
        }
        if (ent instanceof LivingEntity && data[0].equalsIgnoreCase("health")) {
            try {
                double health = Double.parseDouble(data[1]);
                if (((LivingEntity)ent).getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue() < health) {
                    ((LivingEntity)ent).getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(health);
                }
                ((LivingEntity)ent).setHealth(health);
            }
            catch (Exception health) {
                // empty catch block
            }
        }
        switch (ent.getType()) {
            case CREEPER: {
                if (!data[0].equalsIgnoreCase("charged")) break;
                ((Creeper)ent).setPowered(true);
                break;
            }
            case PIG: {
                if (!data[0].equalsIgnoreCase("saddle")) break;
                ((Pig)ent).setSaddle(true);
                break;
            }
            case SLIME: {
                if (data[0].equalsIgnoreCase("huge")) {
                    ((Slime)ent).setSize(16);
                    break;
                }
                if (data[0].equalsIgnoreCase("large")) {
                    ((Slime)ent).setSize(11);
                    break;
                }
                if (data[0].equalsIgnoreCase("normal")) {
                    ((Slime)ent).setSize(6);
                    break;
                }
                if (data[0].equalsIgnoreCase("small")) {
                    ((Slime)ent).setSize(3);
                    break;
                }
                if (!data[0].equalsIgnoreCase("size")) break;
                try {
                    int size = Integer.parseInt(data[1]);
                    ((Slime)ent).setSize(size);
                }
                catch (Exception size) {}
                break;
            }
            case MAGMA_CUBE: {
                if (data[0].equalsIgnoreCase("huge")) {
                    ((MagmaCube)ent).setSize(16);
                    break;
                }
                if (data[0].equalsIgnoreCase("large")) {
                    ((MagmaCube)ent).setSize(11);
                    break;
                }
                if (data[0].equalsIgnoreCase("normal")) {
                    ((MagmaCube)ent).setSize(6);
                    break;
                }
                if (data[0].equalsIgnoreCase("small")) {
                    ((MagmaCube)ent).setSize(3);
                    break;
                }
                if (!data[0].equalsIgnoreCase("size")) break;
                try {
                    int size = Integer.parseInt(data[1]);
                    ((MagmaCube)ent).setSize(size);
                }
                catch (Exception size) {}
                break;
            }
            case WOLF: {
                if (data[0].equalsIgnoreCase("angry")) {
                    ((Wolf)ent).setAngry(true);
                    break;
                }
                if (!data[0].equalsIgnoreCase("collar")) break;
                ((Wolf)ent).setCollarColor(DyeColor.valueOf((String)data[1]));
                break;
            }
            case ENDERMAN: {
                if (!data[0].equalsIgnoreCase("block")) break;
                try {
                    StringBuilder bits = new StringBuilder(data[1]);
                    for (int i = 2; i < data.length; ++i) {
                        bits.append(':').append(data[i]);
                    }
                    BlockStateHolder blockState = (BlockStateHolder)WorldEdit.getInstance().getBlockFactory().parseFromInput(bits.toString(), new ParserContext());
                    ((Enderman)ent).setCarriedBlock(BukkitAdapter.adapt((BlockStateHolder)blockState));
                }
                catch (Exception bits) {}
                break;
            }
            case PRIMED_TNT: {
                if (data[0].equalsIgnoreCase("fuse")) {
                    try {
                        int length = Integer.parseInt(data[1]);
                        ((TNTPrimed)ent).setFuseTicks(length);
                    }
                    catch (Exception length) {}
                    break;
                }
                if (data[0].equalsIgnoreCase("yield")) {
                    try {
                        float yield = Float.parseFloat(data[1]);
                        ((TNTPrimed)ent).setYield(yield);
                    }
                    catch (Exception exception) {}
                    break;
                }
                if (!data[0].equalsIgnoreCase("fire")) break;
                ((TNTPrimed)ent).setIsIncendiary(true);
                break;
            }
            case ARROW: {
                if (data[0].equalsIgnoreCase("fire")) {
                    ent.setFireTicks(5000);
                }
                if (!data[0].equalsIgnoreCase("bounce")) break;
                ((Arrow)ent).setBounce(true);
                break;
            }
            case OCELOT: {
                if (StringUtils.replace((String)StringUtils.replace((String)data[0], (String)"_CAT", (String)""), (String)"_OCELOT", (String)"").equalsIgnoreCase("WILD")) {
                    ((Ocelot)ent).setCatType(Ocelot.Type.WILD_OCELOT);
                }
                if (StringUtils.replace((String)StringUtils.replace((String)data[0], (String)"_CAT", (String)""), (String)"_OCELOT", (String)"").equalsIgnoreCase("BLACK")) {
                    ((Ocelot)ent).setCatType(Ocelot.Type.BLACK_CAT);
                }
                if (StringUtils.replace((String)StringUtils.replace((String)data[0], (String)"_CAT", (String)""), (String)"_OCELOT", (String)"").equalsIgnoreCase("RED")) {
                    ((Ocelot)ent).setCatType(Ocelot.Type.RED_CAT);
                }
                if (!StringUtils.replace((String)StringUtils.replace((String)data[0], (String)"_CAT", (String)""), (String)"_OCELOT", (String)"").equalsIgnoreCase("SIAMESE")) break;
                ((Ocelot)ent).setCatType(Ocelot.Type.SIAMESE_CAT);
                break;
            }
            case THROWN_EXP_BOTTLE: {
                if (!data[0].equalsIgnoreCase("bounce")) break;
                ((ThrownExpBottle)ent).setBounce(true);
                break;
            }
            case PIG_ZOMBIE: {
                if (!data[0].equalsIgnoreCase("angry")) break;
                ((PigZombie)ent).setAngry(true);
                break;
            }
            case VILLAGER: {
                if (data[0].equalsIgnoreCase("butcher")) {
                    ((Villager)ent).setProfession(Villager.Profession.BUTCHER);
                    break;
                }
                if (data[0].equalsIgnoreCase("toolsmith")) {
                    ((Villager)ent).setProfession(Villager.Profession.TOOLSMITH);
                    break;
                }
                if (data[0].equalsIgnoreCase("wepsmith") || data[0].equalsIgnoreCase("smith")) {
                    ((Villager)ent).setProfession(Villager.Profession.WEAPONSMITH);
                    break;
                }
                if (data[0].equalsIgnoreCase("priest")) {
                    ((Villager)ent).setProfession(Villager.Profession.CLERIC);
                    break;
                }
                if (data[0].equalsIgnoreCase("library")) {
                    ((Villager)ent).setProfession(Villager.Profession.LIBRARIAN);
                    break;
                }
                if (!data[0].equalsIgnoreCase("farmer")) break;
                ((Villager)ent).setProfession(Villager.Profession.FARMER);
                break;
            }
            case SHEEP: {
                if (data[0].equalsIgnoreCase("black")) {
                    ((Sheep)ent).setColor(DyeColor.BLACK);
                    break;
                }
                if (data[0].equalsIgnoreCase("red")) {
                    ((Sheep)ent).setColor(DyeColor.RED);
                    break;
                }
                if (data[0].equalsIgnoreCase("green")) {
                    ((Sheep)ent).setColor(DyeColor.GREEN);
                    break;
                }
                if (data[0].equalsIgnoreCase("brown")) {
                    ((Sheep)ent).setColor(DyeColor.BROWN);
                    break;
                }
                if (data[0].equalsIgnoreCase("blue")) {
                    ((Sheep)ent).setColor(DyeColor.BLUE);
                    break;
                }
                if (data[0].equalsIgnoreCase("purple")) {
                    ((Sheep)ent).setColor(DyeColor.PURPLE);
                    break;
                }
                if (data[0].equalsIgnoreCase("cyan")) {
                    ((Sheep)ent).setColor(DyeColor.CYAN);
                    break;
                }
                if (data[0].equalsIgnoreCase("silver")) {
                    ((Sheep)ent).setColor(DyeColor.LIGHT_GRAY);
                    break;
                }
                if (data[0].equalsIgnoreCase("gray")) {
                    ((Sheep)ent).setColor(DyeColor.GRAY);
                    break;
                }
                if (data[0].equalsIgnoreCase("pink")) {
                    ((Sheep)ent).setColor(DyeColor.PINK);
                    break;
                }
                if (data[0].equalsIgnoreCase("lime")) {
                    ((Sheep)ent).setColor(DyeColor.LIME);
                    break;
                }
                if (data[0].equalsIgnoreCase("yellow")) {
                    ((Sheep)ent).setColor(DyeColor.YELLOW);
                    break;
                }
                if (data[0].equalsIgnoreCase("lblue")) {
                    ((Sheep)ent).setColor(DyeColor.LIGHT_BLUE);
                    break;
                }
                if (data[0].equalsIgnoreCase("magenta")) {
                    ((Sheep)ent).setColor(DyeColor.MAGENTA);
                    break;
                }
                if (data[0].equalsIgnoreCase("orange")) {
                    ((Sheep)ent).setColor(DyeColor.ORANGE);
                    break;
                }
                if (!data[0].equalsIgnoreCase("white")) break;
                ((Sheep)ent).setColor(DyeColor.WHITE);
                break;
            }
            case HORSE: {
                if (ent instanceof ChestedHorse && data[0].equalsIgnoreCase("chest")) {
                    ((ChestedHorse)ent).setCarryingChest(true);
                    break;
                }
                if (data[0].equalsIgnoreCase("domestic")) {
                    try {
                        ((Horse)ent).setDomestication(Integer.parseInt(data[1]));
                    }
                    catch (Exception exception) {}
                    break;
                }
                if (data[0].equalsIgnoreCase("c")) {
                    if (data[1].equalsIgnoreCase("white")) {
                        ((Horse)ent).setColor(Horse.Color.WHITE);
                        break;
                    }
                    if (data[1].equalsIgnoreCase("cream")) {
                        ((Horse)ent).setColor(Horse.Color.CREAMY);
                        break;
                    }
                    if (data[1].equalsIgnoreCase("chestnut")) {
                        ((Horse)ent).setColor(Horse.Color.CHESTNUT);
                        break;
                    }
                    if (data[1].equalsIgnoreCase("brown")) {
                        ((Horse)ent).setColor(Horse.Color.BROWN);
                        break;
                    }
                    if (data[1].equalsIgnoreCase("dbrown")) {
                        ((Horse)ent).setColor(Horse.Color.DARK_BROWN);
                        break;
                    }
                    if (data[1].equalsIgnoreCase("gray")) {
                        ((Horse)ent).setColor(Horse.Color.GRAY);
                        break;
                    }
                    if (!data[1].equalsIgnoreCase("black")) break;
                    ((Horse)ent).setColor(Horse.Color.BLACK);
                    break;
                }
                if (data[0].equalsIgnoreCase("m")) {
                    if (data[1].equalsIgnoreCase("none")) {
                        ((Horse)ent).setStyle(Horse.Style.NONE);
                        break;
                    }
                    if (data[1].equalsIgnoreCase("white")) {
                        ((Horse)ent).setStyle(Horse.Style.NONE);
                        break;
                    }
                    if (data[1].equalsIgnoreCase("milky")) {
                        ((Horse)ent).setStyle(Horse.Style.WHITEFIELD);
                        break;
                    }
                    if (data[1].equalsIgnoreCase("wdots")) {
                        ((Horse)ent).setStyle(Horse.Style.WHITE_DOTS);
                        break;
                    }
                    if (!data[1].equalsIgnoreCase("bdots")) break;
                    ((Horse)ent).setStyle(Horse.Style.BLACK_DOTS);
                    break;
                }
                if (!data[0].equalsIgnoreCase("strength")) break;
                try {
                    ((Horse)ent).setJumpStrength(Double.parseDouble(data[1]));
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

