/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;

public class BlockSyntax {
    private static ParserContext BLOCK_CONTEXT = new ParserContext();
    private static Set<String> knownBadLines = new HashSet<String>();

    public static BaseBlock getBlock(String line) {
        return BlockSyntax.getBlock(line, false);
    }

    public static BaseBlock getBlock(String line, boolean wild) {
        if (line == null || line.trim().isEmpty() || knownBadLines.contains(line)) {
            return null;
        }
        BLOCK_CONTEXT.setPreferringWildcard(wild);
        BaseBlock blockState = null;
        try {
            blockState = (BaseBlock)WorldEdit.getInstance().getBlockFactory().parseFromInput(line, BLOCK_CONTEXT);
        }
        catch (InputParseException inputParseException) {
            // empty catch block
        }
        if (blockState == null) {
            String[] dataSplit = RegexUtil.COLON_PATTERN.split(line.replace("\\:", ":"), 2);
            Material material = Material.getMaterial((String)dataSplit[0], (boolean)true);
            if (material != null) {
                int data = 0;
                if (dataSplit.length > 1 && ((data = Integer.parseInt(dataSplit[1])) < 0 || data > 15)) {
                    data = 0;
                }
                blockState = LegacyMapper.getInstance().getBlockFromLegacy(BukkitAdapter.asBlockType((Material)material).getLegacyId(), data).toBaseBlock();
            }
            if (material == null) {
                CraftBookPlugin.logger().warning("Invalid block format: " + line);
                knownBadLines.add(line);
            }
        }
        return blockState;
    }

    public static List<BaseBlock> getBlocks(List<String> lines) {
        return BlockSyntax.getBlocks(lines, false);
    }

    public static List<BaseBlock> getBlocks(List<String> lines, boolean wild) {
        return lines.stream().map(line -> BlockSyntax.getBlock(line, wild)).collect(Collectors.toList());
    }

    public static BlockData getBukkitBlock(String line) {
        return BukkitAdapter.adapt((BlockStateHolder)BlockSyntax.getBlock(line));
    }

    public static String toMinifiedId(BlockType holder) {
        String output = holder.getId();
        if (output.startsWith("minecraft:")) {
            output = output.substring(10);
        }
        return output;
    }

    public static String toMinifiedId(BlockStateHolder holder) {
        String output = holder.getAsString();
        if (output.startsWith("minecraft:")) {
            output = output.substring(10);
        }
        return output;
    }

    static {
        BLOCK_CONTEXT.setPreferringWildcard(true);
        BLOCK_CONTEXT.setRestricted(false);
    }
}

