/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.variables;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.variables.VariableConfiguration;
import com.sk89q.craftbook.mechanics.variables.VariablePacketModifier;
import com.sk89q.craftbook.util.LoadPriority;
import com.sk89q.craftbook.util.ParsingUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.craftbook.util.Tuple2;
import com.sk89q.craftbook.util.events.SelfTriggerPingEvent;
import com.sk89q.squirrelid.Profile;
import com.sk89q.squirrelid.resolver.HttpRepositoryService;
import com.sk89q.squirrelid.resolver.ProfileService;
import com.sk89q.util.yaml.YAMLFormat;
import com.sk89q.util.yaml.YAMLProcessor;
import java.io.File;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;

public class VariableManager
extends AbstractCraftBookMechanic {
    private VariableConfiguration variableConfiguration;
    public static VariableManager instance;
    private HashMap<Tuple2<String, String>, String> variableStore;
    boolean defaultToGlobal;
    private boolean consoleOverride;
    private boolean playerCommandOverride;
    private boolean playerChatOverride;
    private boolean packetMessageOverride;

    @Override
    public boolean enable() {
        instance = this;
        this.variableStore = new HashMap();
        CraftBookPlugin.logDebugMessage("Initializing Variables!", "startup.variables");
        try {
            File varFile = new File(CraftBookPlugin.inst().getDataFolder(), "variables.yml");
            if (!varFile.exists()) {
                varFile.createNewFile();
            }
            this.variableConfiguration = new VariableConfiguration(new YAMLProcessor(varFile, true, YAMLFormat.EXTENDED), CraftBookPlugin.logger());
            this.variableConfiguration.load();
        }
        catch (Exception ignored) {
            CraftBookBukkitUtil.printStacktrace(ignored);
            return false;
        }
        if (this.packetMessageOverride) {
            new VariablePacketModifier();
        }
        return true;
    }

    @Override
    public void disable() {
        if (this.variableConfiguration != null) {
            this.variableConfiguration.save();
            this.variableConfiguration = null;
        }
        this.variableStore.clear();
        instance = null;
    }

    public boolean hasVariable(String variable, String namespace) {
        return this.variableStore.containsKey(new Tuple2<String, String>(variable, namespace));
    }

    public String getVariable(String variable, String namespace) {
        return this.variableStore.get(new Tuple2<String, String>(variable, namespace));
    }

    public String setVariable(String variable, String namespace, String value) {
        return this.variableStore.put(new Tuple2<String, String>(variable, namespace), value);
    }

    public String removeVariable(String variable, String namespace) {
        return this.variableStore.remove(new Tuple2<String, String>(variable, namespace));
    }

    public HashMap<Tuple2<String, String>, String> getVariableStore() {
        return this.variableStore;
    }

    public static String getNamespace(String variable) {
        if (variable.contains("|")) {
            String[] bits = RegexUtil.PIPE_PATTERN.split(variable);
            if (bits.length < 2) {
                return "global";
            }
            return bits[0];
        }
        return "global";
    }

    public static String getVariableName(String variable) {
        if (variable.contains("|")) {
            String[] bits = RegexUtil.PIPE_PATTERN.split(variable);
            if (bits.length < 2) {
                return variable;
            }
            return bits[1];
        }
        return variable;
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (this.playerChatOverride && event.getPlayer().hasPermission("craftbook.variables.chat")) {
            event.setMessage(ParsingUtil.parseVariables(event.getMessage(), (CommandSender)event.getPlayer()));
        }
    }

    @EventHandler
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (this.playerCommandOverride && event.getPlayer().hasPermission("craftbook.variables.commands")) {
            event.setMessage(ParsingUtil.parseVariables(event.getMessage(), (CommandSender)event.getPlayer()));
        }
    }

    @EventHandler
    public void onConsoleCommandPreprocess(ServerCommandEvent event) {
        if (this.consoleOverride) {
            event.setCommand(ParsingUtil.parseVariables(event.getCommand(), null));
        }
    }

    @EventHandler
    public void onSelfTriggerPing(SelfTriggerPingEvent event) {
        if (!CraftBookPlugin.inst().getConfiguration().convertNamesToCBID) {
            return;
        }
        if (SignUtil.isSign(event.getBlock())) {
            ChangedSign sign = CraftBookBukkitUtil.toChangedSign(event.getBlock());
            int i = 0;
            for (String line : sign.getLines()) {
                for (String var : ParsingUtil.getPossibleVariables(line)) {
                    OfflinePlayer player;
                    String namespace = VariableManager.getNamespace(var);
                    if (namespace == null || namespace.isEmpty() || namespace.equals("global") || CraftBookPlugin.inst().getUUIDMappings().getUUID(namespace) != null || !(player = Bukkit.getOfflinePlayer((String)namespace)).hasPlayedBefore()) continue;
                    try {
                        ProfileService resolver = HttpRepositoryService.forMinecraft();
                        Profile profile = resolver.findByName(player.getName());
                        UUID uuid = profile.getUniqueId();
                        line = StringUtils.replace((String)line, (String)var, (String)var.replace(namespace, CraftBookPlugin.inst().getUUIDMappings().getCBID(uuid)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                sign.setLine(i++, line);
            }
            sign.update(false);
        }
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "default-to-global", "When a variable is accessed via command, if no namespace is provided... It will default to global. If this is false, it will use the players name.");
        this.defaultToGlobal = config.getBoolean(path + "default-to-global", false);
        config.setComment(path + "enable-in-console", "Allows variables to work on the Console.");
        this.consoleOverride = config.getBoolean(path + "enable-in-console", false);
        config.setComment(path + "enable-in-player-commands", "Allows variables to work in any command a player performs.");
        this.playerCommandOverride = config.getBoolean(path + "enable-in-player-commands", false);
        config.setComment(path + "enable-in-player-chat", "Allow variables to work in player chat.");
        this.playerChatOverride = config.getBoolean(path + "enable-in-player-chat", false);
        config.setComment(path + "override-all-text", "Modify outgoing packets to replace variables in all text. (Requires ProtocolLib)");
        this.packetMessageOverride = config.getBoolean(path + "override-all-text", false);
    }

    @Override
    public LoadPriority getLoadPriority() {
        return LoadPriority.EARLY;
    }
}

