/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.variables;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICManager;
import com.sk89q.craftbook.mechanics.variables.VariableManager;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.Tuple2;
import com.sk89q.craftbook.util.exceptions.FastCommandException;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissionsException;
import java.util.ArrayList;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class VariableCommands {
    private CraftBookPlugin plugin;

    public VariableCommands(CraftBookPlugin plugin) {
        this.plugin = plugin;
    }

    @Command(aliases={"set"}, desc="Sets a variable.", max=2, min=2, flags="n:", usage="<Variable> <Value> -n <Namespace>")
    public void set(CommandContext context, CommandSender sender) throws CommandException {
        if (VariableManager.instance == null) {
            sender.sendMessage(ChatColor.RED + "Variables are not enabled!");
            return;
        }
        String key = "global";
        if (!VariableManager.instance.defaultToGlobal && sender instanceof Player) {
            key = CraftBookPlugin.inst().wrapPlayer((Player)sender).getCraftBookId();
        }
        if (context.hasFlag('n')) {
            key = context.getFlag('n');
        }
        if (VariableManager.instance.hasVariable(context.getString(0), key)) {
            if (!RegexUtil.VARIABLE_KEY_PATTERN.matcher(context.getString(0)).find()) {
                throw new FastCommandException("Invalid Variable Name!");
            }
            VariableCommands.checkModifyPermissions(sender, key, context.getString(0));
            if (!RegexUtil.VARIABLE_VALUE_PATTERN.matcher(context.getString(1)).find()) {
                throw new FastCommandException("Invalid Variable Value!");
            }
        } else {
            throw new FastCommandException("Unknown Variable!");
        }
        VariableManager.instance.setVariable(context.getString(0), key, context.getString(1));
        VariableCommands.resetICCache(context.getString(0), key);
        sender.sendMessage(ChatColor.YELLOW + "Variable is now: " + VariableManager.instance.getVariable(context.getString(0), key));
    }

    @Command(aliases={"define"}, desc="Defines a variable.", max=2, min=2, flags="n:", usage="<Variable> <Value> -n <Namespace>")
    public void define(CommandContext context, CommandSender sender) throws CommandException {
        if (VariableManager.instance == null) {
            sender.sendMessage(ChatColor.RED + "Variables are not enabled!");
            return;
        }
        String key = "global";
        if (!VariableManager.instance.defaultToGlobal && sender instanceof Player) {
            key = CraftBookPlugin.inst().wrapPlayer((Player)sender).getCraftBookId();
        }
        if (context.hasFlag('n')) {
            key = context.getFlag('n');
        }
        if (!VariableManager.instance.hasVariable(context.getString(0), key)) {
            if (!VariableCommands.hasVariablePermission(sender, key, context.getString(0), "define")) {
                throw new CommandPermissionsException();
            }
            if (!RegexUtil.VARIABLE_KEY_PATTERN.matcher(context.getString(0)).find()) {
                throw new FastCommandException("Invalid Variable Name!");
            }
            if (!RegexUtil.VARIABLE_VALUE_PATTERN.matcher(context.getString(1)).find()) {
                throw new FastCommandException("Invalid Variable Value!");
            }
        } else {
            throw new FastCommandException("Existing Variable!");
        }
        VariableManager.instance.setVariable(context.getString(0), key, context.getString(1));
        VariableCommands.resetICCache(context.getString(0), key);
        sender.sendMessage(ChatColor.YELLOW + "Variable is now: " + VariableManager.instance.getVariable(context.getString(0), key));
    }

    @Command(aliases={"get"}, desc="Checks a variable.", max=1, min=1, flags="n:", usage="<Variable> -n <Namespace>")
    public void get(CommandContext context, CommandSender sender) throws CommandException {
        if (VariableManager.instance == null) {
            sender.sendMessage(ChatColor.RED + "Variables are not enabled!");
            return;
        }
        String key = "global";
        if (!VariableManager.instance.defaultToGlobal && sender instanceof Player) {
            key = CraftBookPlugin.inst().wrapPlayer((Player)sender).getCraftBookId();
        }
        if (context.hasFlag('n')) {
            key = context.getFlag('n');
        }
        if (VariableManager.instance.hasVariable(context.getString(0), key)) {
            if (!VariableCommands.hasVariablePermission(sender, key, context.getString(0), "get")) {
                throw new CommandPermissionsException();
            }
            if (!RegexUtil.VARIABLE_KEY_PATTERN.matcher(context.getString(0)).find()) {
                throw new FastCommandException("Invalid Variable Name!");
            }
        } else {
            throw new FastCommandException("Unknown Variable!");
        }
        sender.sendMessage(ChatColor.YELLOW + context.getString(0) + ": " + VariableManager.instance.getVariable(context.getString(0), key));
    }

    @Command(aliases={"list"}, desc="Lists variables", flags="an:p:", usage="-p <page> -n <Namespace> -a")
    public void list(CommandContext context, CommandSender sender) throws CommandException {
        int accessedPage;
        if (VariableManager.instance == null) {
            sender.sendMessage(ChatColor.RED + "Variables are not enabled!");
            return;
        }
        String key = "global";
        if (!VariableManager.instance.defaultToGlobal && sender instanceof Player) {
            key = CraftBookPlugin.inst().wrapPlayer((Player)sender).getCraftBookId();
        }
        if (context.hasFlag('n')) {
            key = context.getFlag('n');
        }
        if (context.hasFlag('a')) {
            key = null;
        }
        ArrayList<String> variablesLines = new ArrayList<String>();
        for (Map.Entry<Tuple2<String, String>, String> entry : VariableManager.instance.getVariableStore().entrySet()) {
            if (key != null && !((String)entry.getKey().b).equals(key)) continue;
            String keyName = (String)entry.getKey().a;
            if (key == null) {
                keyName = (String)entry.getKey().b + '|' + keyName;
            }
            variablesLines.add(ChatColor.YELLOW + keyName + ChatColor.WHITE + ": " + ChatColor.GREEN + entry.getValue());
        }
        String[] lines = variablesLines.toArray(new String[variablesLines.size()]);
        int pages = (lines.length - 1) / 9 + 1;
        try {
            int n = accessedPage = !context.hasFlag('p') ? 0 : context.getFlagInteger('p') - 1;
            if (accessedPage < 0 || accessedPage >= pages) {
                sender.sendMessage(ChatColor.RED + "Invalid page \"" + context.getFlagInteger('p') + '\"');
                return;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(ChatColor.RED + "Invalid page \"" + context.getFlag('p') + '\"');
            return;
        }
        sender.sendMessage(ChatColor.BLUE + "  ");
        sender.sendMessage(ChatColor.BLUE + "Variables (Page " + (accessedPage + 1) + " of " + pages + "):");
        for (int i = accessedPage * 9; i < lines.length && i < (accessedPage + 1) * 9; ++i) {
            sender.sendMessage(lines[i]);
        }
    }

    @Command(aliases={"erase", "remove", "delete", "rm"}, desc="Erase a variable.", max=1, min=1, flags="n:", usage="<Variable> -n <Namespace>")
    public void erase(CommandContext context, CommandSender sender) throws CommandException {
        if (VariableManager.instance == null) {
            sender.sendMessage(ChatColor.RED + "Variables are not enabled!");
            return;
        }
        String key = "global";
        if (!VariableManager.instance.defaultToGlobal && sender instanceof Player) {
            key = CraftBookPlugin.inst().wrapPlayer((Player)sender).getCraftBookId();
        }
        if (context.hasFlag('n')) {
            key = context.getFlag('n');
        }
        if (VariableManager.instance.hasVariable(context.getString(0), key)) {
            if (!VariableCommands.hasVariablePermission(sender, key, context.getString(0), "erase")) {
                throw new CommandPermissionsException();
            }
            if (!RegexUtil.VARIABLE_KEY_PATTERN.matcher(context.getString(0)).find()) {
                throw new FastCommandException("Invalid Variable Name!");
            }
        } else {
            throw new FastCommandException("Unknown Variable!");
        }
        VariableManager.instance.removeVariable(context.getString(0), key);
        VariableCommands.resetICCache(context.getString(0), key);
        sender.sendMessage(ChatColor.YELLOW + "Removed variable: " + context.getString(0));
    }

    private static void resetICCache(String variable, String namespace) {
        if (ICManager.inst() != null) {
            ICManager.getCachedICs().entrySet().removeIf(ic -> ((IC)ic.getValue()).getSign().hasVariable(namespace + '|' + variable) || ((IC)ic.getValue()).getSign().hasVariable(variable));
        }
    }

    @Command(aliases={"append"}, desc="Append to a variable.", max=2, min=2, flags="n:", usage="<Variable> <Appended Value> -n <Namespace>")
    public void append(CommandContext context, CommandSender sender) throws CommandException {
        if (VariableManager.instance == null) {
            sender.sendMessage(ChatColor.RED + "Variables are not enabled!");
            return;
        }
        String key = "global";
        if (!VariableManager.instance.defaultToGlobal && sender instanceof Player) {
            key = CraftBookPlugin.inst().wrapPlayer((Player)sender).getCraftBookId();
        }
        if (context.hasFlag('n')) {
            key = context.getFlag('n');
        }
        if (VariableManager.instance.hasVariable(context.getString(0), key)) {
            if (!RegexUtil.VARIABLE_KEY_PATTERN.matcher(context.getString(0)).find()) {
                throw new FastCommandException("Invalid Variable Name!");
            }
            VariableCommands.checkModifyPermissions(sender, key, context.getString(0));
            if (!RegexUtil.VARIABLE_VALUE_PATTERN.matcher(context.getString(1)).find()) {
                throw new FastCommandException("Invalid Variable Value!");
            }
        } else {
            throw new FastCommandException("Unknown Variable!");
        }
        VariableManager.instance.setVariable(context.getString(0), key, VariableManager.instance.getVariable(context.getString(0), key) + context.getString(1));
        VariableCommands.resetICCache(context.getString(0), key);
        sender.sendMessage(ChatColor.YELLOW + "Variable is now: " + VariableManager.instance.getVariable(context.getString(0), key));
    }

    @Command(aliases={"prepend"}, desc="Prepend to a variable.", max=2, min=2, flags="n:", usage="<Variable> <Prepended Value> -n <Namespace>")
    public void prepend(CommandContext context, CommandSender sender) throws CommandException {
        if (VariableManager.instance == null) {
            sender.sendMessage(ChatColor.RED + "Variables are not enabled!");
            return;
        }
        String key = "global";
        if (!VariableManager.instance.defaultToGlobal && sender instanceof Player) {
            key = CraftBookPlugin.inst().wrapPlayer((Player)sender).getCraftBookId();
        }
        if (context.hasFlag('n')) {
            key = context.getFlag('n');
        }
        if (VariableManager.instance.hasVariable(context.getString(0), key)) {
            if (!RegexUtil.VARIABLE_KEY_PATTERN.matcher(context.getString(0)).find()) {
                throw new FastCommandException("Invalid Variable Name!");
            }
            VariableCommands.checkModifyPermissions(sender, key, context.getString(0));
            if (!RegexUtil.VARIABLE_VALUE_PATTERN.matcher(context.getString(1)).find()) {
                throw new FastCommandException("Invalid Variable Value!");
            }
        } else {
            throw new FastCommandException("Unknown Variable!");
        }
        VariableManager.instance.setVariable(context.getString(0), key, context.getString(1) + VariableManager.instance.getVariable(context.getString(0), key));
        VariableCommands.resetICCache(context.getString(0), key);
        sender.sendMessage(ChatColor.YELLOW + "Variable is now: " + VariableManager.instance.getVariable(context.getString(0), key));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Command(aliases={"toggle"}, desc="Toggle a boolean.", max=1, min=1, flags="n:", usage="<Variable> -n <Namespace>")
    public void toggle(CommandContext context, CommandSender sender) throws CommandException {
        if (VariableManager.instance == null) {
            sender.sendMessage(ChatColor.RED + "Variables are not enabled!");
            return;
        }
        String key = "global";
        if (!VariableManager.instance.defaultToGlobal && sender instanceof Player) {
            key = CraftBookPlugin.inst().wrapPlayer((Player)sender).getCraftBookId();
        }
        if (context.hasFlag('n')) {
            key = context.getFlag('n');
        }
        if (!VariableManager.instance.hasVariable(context.getString(0), key)) throw new FastCommandException("Unknown Variable!");
        if (!RegexUtil.VARIABLE_KEY_PATTERN.matcher(context.getString(0)).find()) {
            throw new FastCommandException("Invalid Variable Name!");
        }
        VariableCommands.checkModifyPermissions(sender, key, context.getString(0));
        String var = VariableManager.instance.getVariable(context.getString(0), key);
        if (var.equalsIgnoreCase("0") || var.equalsIgnoreCase("1")) {
            var = var.equalsIgnoreCase("1") ? "0" : "1";
        } else if (var.equalsIgnoreCase("true") || var.equalsIgnoreCase("false")) {
            var = var.equalsIgnoreCase("true") ? "false" : "true";
        } else {
            if (!var.equalsIgnoreCase("yes") && !var.equalsIgnoreCase("no")) throw new FastCommandException("Variable not of boolean type!");
            var = var.equalsIgnoreCase("yes") ? "no" : "yes";
        }
        VariableManager.instance.setVariable(context.getString(0), key, var);
        VariableCommands.resetICCache(context.getString(0), key);
        sender.sendMessage(ChatColor.YELLOW + "Variable is now: " + var);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Command(aliases={"add"}, desc="Add to a numeric variable.", max=2, min=2, flags="n:", usage="<Variable> <Added Value> -n <Namespace>")
    public void add(CommandContext context, CommandSender sender) throws CommandException {
        if (VariableManager.instance == null) {
            sender.sendMessage(ChatColor.RED + "Variables are not enabled!");
            return;
        }
        String key = "global";
        if (!VariableManager.instance.defaultToGlobal && sender instanceof Player) {
            key = CraftBookPlugin.inst().wrapPlayer((Player)sender).getCraftBookId();
        }
        if (context.hasFlag('n')) {
            key = context.getFlag('n');
        }
        if (!VariableManager.instance.hasVariable(context.getString(0), key)) throw new FastCommandException("Unknown Variable!");
        if (!RegexUtil.VARIABLE_KEY_PATTERN.matcher(context.getString(0)).find()) {
            throw new FastCommandException("Invalid Variable Name!");
        }
        VariableCommands.checkModifyPermissions(sender, key, context.getString(0));
        if (!RegexUtil.VARIABLE_VALUE_PATTERN.matcher(context.getString(1)).find()) {
            throw new FastCommandException("Invalid Variable Value!");
        }
        String var = VariableManager.instance.getVariable(context.getString(0), key);
        try {
            double f = Double.parseDouble(var);
            var = String.valueOf(f += context.getDouble(1));
            if (var.endsWith(".0")) {
                var = var.replace(".0", "");
            }
        }
        catch (Exception e) {
            throw new FastCommandException("Variable not of numeric type!");
        }
        VariableManager.instance.setVariable(context.getString(0), key, var);
        VariableCommands.resetICCache(context.getString(0), key);
        sender.sendMessage(ChatColor.YELLOW + "Variable is now: " + var);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Command(aliases={"subtract"}, desc="Subtract from a numeric variable.", max=2, min=2, flags="n:", usage="<Variable> <Subtracting Value> -n <Namespace>")
    public void subtract(CommandContext context, CommandSender sender) throws CommandException {
        if (VariableManager.instance == null) {
            sender.sendMessage(ChatColor.RED + "Variables are not enabled!");
            return;
        }
        String key = "global";
        if (!VariableManager.instance.defaultToGlobal && sender instanceof Player) {
            key = CraftBookPlugin.inst().wrapPlayer((Player)sender).getCraftBookId();
        }
        if (context.hasFlag('n')) {
            key = context.getFlag('n');
        }
        if (!VariableManager.instance.hasVariable(context.getString(0), key)) throw new FastCommandException("Unknown Variable!");
        if (!RegexUtil.VARIABLE_KEY_PATTERN.matcher(context.getString(0)).find()) {
            throw new FastCommandException("Invalid Variable Name!");
        }
        VariableCommands.checkModifyPermissions(sender, key, context.getString(0));
        if (!RegexUtil.VARIABLE_VALUE_PATTERN.matcher(context.getString(1)).find()) {
            throw new FastCommandException("Invalid Variable Value!");
        }
        String var = VariableManager.instance.getVariable(context.getString(0), key);
        try {
            double f = Double.parseDouble(var);
            var = String.valueOf(f -= context.getDouble(1));
            if (var.endsWith(".0")) {
                var = var.replace(".0", "");
            }
        }
        catch (Exception e) {
            throw new FastCommandException("Variable not of numeric type!");
        }
        VariableManager.instance.setVariable(context.getString(0), key, var);
        VariableCommands.resetICCache(context.getString(0), key);
        sender.sendMessage(ChatColor.YELLOW + "Variable is now: " + var);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Command(aliases={"multiply", "multiple"}, desc="Multiply a numeric variable.", max=2, min=2, flags="n:", usage="<Variable> <Multiplying Value> -n <Namespace>")
    public void multiple(CommandContext context, CommandSender sender) throws CommandException {
        if (VariableManager.instance == null) {
            sender.sendMessage(ChatColor.RED + "Variables are not enabled!");
            return;
        }
        String key = "global";
        if (!VariableManager.instance.defaultToGlobal && sender instanceof Player) {
            key = CraftBookPlugin.inst().wrapPlayer((Player)sender).getCraftBookId();
        }
        if (context.hasFlag('n')) {
            key = context.getFlag('n');
        }
        if (!VariableManager.instance.hasVariable(context.getString(0), key)) throw new FastCommandException("Unknown Variable!");
        if (!RegexUtil.VARIABLE_KEY_PATTERN.matcher(context.getString(0)).find()) {
            throw new FastCommandException("Invalid Variable Name!");
        }
        VariableCommands.checkModifyPermissions(sender, key, context.getString(0));
        if (!RegexUtil.VARIABLE_VALUE_PATTERN.matcher(context.getString(1)).find()) {
            throw new FastCommandException("Invalid Variable Value!");
        }
        String var = VariableManager.instance.getVariable(context.getString(0), key);
        try {
            double f = Double.parseDouble(var);
            var = String.valueOf(f *= context.getDouble(1));
            if (var.endsWith(".0")) {
                var = var.replace(".0", "");
            }
        }
        catch (Exception e) {
            throw new FastCommandException("Variable not of numeric type!");
        }
        VariableManager.instance.setVariable(context.getString(0), key, var);
        VariableCommands.resetICCache(context.getString(0), key);
        sender.sendMessage(ChatColor.YELLOW + "Variable is now: " + var);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Command(aliases={"divide"}, desc="Divide a numeric variable.", max=2, min=2, flags="n:", usage="<Variable> <Dividing Value> -n <Namespace>")
    public void divide(CommandContext context, CommandSender sender) throws CommandException {
        if (VariableManager.instance == null) {
            sender.sendMessage(ChatColor.RED + "Variables are not enabled!");
            return;
        }
        String key = "global";
        if (!VariableManager.instance.defaultToGlobal && sender instanceof Player) {
            key = CraftBookPlugin.inst().wrapPlayer((Player)sender).getCraftBookId();
        }
        if (context.hasFlag('n')) {
            key = context.getFlag('n');
        }
        if (!VariableManager.instance.hasVariable(context.getString(0), key)) throw new FastCommandException("Unknown Variable!");
        if (!RegexUtil.VARIABLE_KEY_PATTERN.matcher(context.getString(0)).find()) {
            throw new FastCommandException("Invalid Variable Name!");
        }
        VariableCommands.checkModifyPermissions(sender, key, context.getString(0));
        if (!RegexUtil.VARIABLE_VALUE_PATTERN.matcher(context.getString(1)).find()) {
            throw new FastCommandException("Invalid Variable Value!");
        }
        String var = VariableManager.instance.getVariable(context.getString(0), key);
        try {
            double f = Double.parseDouble(var);
            if (f == 0.0) {
                throw new FastCommandException("Can't divide by 0!");
            }
            var = String.valueOf(f /= context.getDouble(1));
            if (var.endsWith(".0")) {
                var = var.replace(".0", "");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FastCommandException("Variable not of numeric type!");
        }
        VariableManager.instance.setVariable(context.getString(0), key, var);
        VariableCommands.resetICCache(context.getString(0), key);
        sender.sendMessage(ChatColor.YELLOW + "Variable is now: " + var);
    }

    private static void checkModifyPermissions(CommandSender sender, String key, String var) throws CommandException {
        if (!VariableCommands.hasVariablePermission(sender, key, var, "modify")) {
            throw new CommandPermissionsException();
        }
    }

    public static boolean hasVariablePermission(CommandSender sender, String namespace, String var, String action) {
        if (sender instanceof Player && namespace.equalsIgnoreCase(CraftBookPlugin.inst().wrapPlayer((Player)sender).getCraftBookId()) && (sender.hasPermission("craftbook.variables." + action + ".self") || sender.hasPermission("craftbook.variables." + action + ".self." + var))) {
            return true;
        }
        return sender.hasPermission("craftbook.variables." + action + "") || sender.hasPermission("craftbook.variables." + action + '.' + namespace) || sender.hasPermission("craftbook.variables." + action + '.' + namespace + '.' + var);
    }
}

