/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.pipe;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.pipe.PipeFinishEvent;
import com.sk89q.craftbook.mechanics.pipe.PipePutEvent;
import com.sk89q.craftbook.mechanics.pipe.PipeRequestEvent;
import com.sk89q.craftbook.mechanics.pipe.PipeSuckEvent;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.BlockUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.InventoryUtil;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.ProtectionUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.craftbook.util.VerifyUtil;
import com.sk89q.craftbook.util.events.SourcedBlockRedstoneEvent;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Dropper;
import org.bukkit.block.Furnace;
import org.bukkit.block.Jukebox;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Piston;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class Pipes
extends AbstractCraftBookMechanic {
    private boolean pipesDiagonal;
    private BlockStateHolder<?> pipeInsulator;
    private boolean pipeStackPerPull;
    private boolean pipeRequireSign;

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!event.getLine(1).equalsIgnoreCase("[pipe]")) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!player.hasPermission("craftbook.circuits.pipes")) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("mech.create-permission");
            }
            SignUtil.cancelSign(event);
            return;
        }
        if (ProtectionUtil.shouldUseProtection()) {
            Block pistonBlock = null;
            if (SignUtil.isWallSign(event.getBlock())) {
                pistonBlock = SignUtil.getBackBlock(event.getBlock());
            } else if (SignUtil.isStandingSign(event.getBlock())) {
                if (Pipes.isPiston(event.getBlock().getRelative(BlockFace.DOWN))) {
                    pistonBlock = event.getBlock().getRelative(BlockFace.DOWN);
                } else if (Pipes.isPiston(event.getBlock().getRelative(BlockFace.UP))) {
                    pistonBlock = event.getBlock().getRelative(BlockFace.UP);
                }
            }
            if (pistonBlock != null && Pipes.isPiston(pistonBlock)) {
                Piston pis = (Piston)pistonBlock.getBlockData();
                Block off = pistonBlock.getRelative(pis.getFacing());
                if (InventoryUtil.doesBlockHaveInventory(off) && !ProtectionUtil.canAccessInventory(event.getPlayer(), off)) {
                    if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                        player.printError("area.use-permission");
                    }
                    SignUtil.cancelSign(event);
                    return;
                }
            } else {
                player.printError("circuits.pipes.pipe-not-found");
                SignUtil.cancelSign(event);
                return;
            }
        }
        event.setLine(1, "[Pipe]");
        player.print("circuits.pipes.create");
    }

    private static boolean isPiston(Block block) {
        return block.getType() == Material.PISTON || block.getType() == Material.STICKY_PISTON;
    }

    private static ChangedSign getSignOnPiston(Block block) {
        BlockData blockData = block.getBlockData();
        BlockFace facing = BlockFace.SELF;
        if (blockData instanceof Directional) {
            facing = ((Directional)blockData).getFacing();
        }
        for (BlockFace face : LocationUtil.getDirectFaces()) {
            ChangedSign sign;
            if (face == facing || !SignUtil.isSign(block.getRelative(face)) || !SignUtil.isStandingSign(block.getRelative(face)) && (face == BlockFace.UP || face == BlockFace.DOWN) || SignUtil.isStandingSign(block.getRelative(face)) && face != BlockFace.UP && face != BlockFace.DOWN || !SignUtil.isStandingSign(block.getRelative(face)) && !SignUtil.getBackBlock(block.getRelative(face)).getLocation().equals((Object)block.getLocation()) || (sign = CraftBookBukkitUtil.toChangedSign(block.getRelative(face))) == null || !sign.getLine(1).equalsIgnoreCase("[Pipe]")) continue;
            return sign;
        }
        return null;
    }

    private void searchNearbyPipes(Block block, Set<Vector> visitedPipes, List<ItemStack> items) {
        ArrayDeque<Block> searchQueue = new ArrayDeque<Block>();
        searchQueue.addFirst(block);
        while (!searchQueue.isEmpty()) {
            Block bl = (Block)searchQueue.poll();
            if (bl.getType() == Material.PISTON) {
                ArrayList<ItemStack> filteredItems;
                Piston p = (Piston)bl.getBlockData();
                ChangedSign sign = Pipes.getSignOnPiston(bl);
                HashSet<ItemStack> pFilters = new HashSet<ItemStack>();
                String[] pExceptions = new HashSet();
                if (sign != null) {
                    for (String line3 : RegexUtil.COMMA_PATTERN.split(sign.getLine(2))) {
                        pFilters.add(ItemSyntax.getItem(line3.trim()));
                    }
                    for (String line4 : RegexUtil.COMMA_PATTERN.split(sign.getLine(3))) {
                        pExceptions.add(ItemSyntax.getItem(line4.trim()));
                    }
                    pFilters.removeAll(Collections.singleton(null));
                    pExceptions.removeAll(Collections.singleton(null));
                }
                if ((filteredItems = new ArrayList<ItemStack>(VerifyUtil.withoutNulls(ItemUtil.filterItems(items, pFilters, pExceptions)))).isEmpty()) continue;
                ArrayList<ItemStack> newItems = new ArrayList<ItemStack>();
                Block fac = bl.getRelative(p.getFacing());
                PipePutEvent event = new PipePutEvent(bl, new ArrayList<ItemStack>(filteredItems), fac);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    if (InventoryUtil.doesBlockHaveInventory(fac)) {
                        InventoryHolder holder = (InventoryHolder)fac.getState();
                        newItems.addAll(InventoryUtil.addItemsToInventory(holder, event.getItems().toArray(new ItemStack[event.getItems().size()])));
                    } else if (fac.getType() == Material.JUKEBOX) {
                        Jukebox juke = (Jukebox)fac.getState();
                        ArrayList<ItemStack> its = new ArrayList<ItemStack>(event.getItems());
                        if (juke.getPlaying() != Material.AIR) {
                            Iterator iter = its.iterator();
                            while (iter.hasNext()) {
                                ItemStack st = (ItemStack)iter.next();
                                if (!st.getType().isRecord()) continue;
                                juke.setPlaying(st.getType());
                                juke.update();
                                iter.remove();
                                break;
                            }
                        }
                        newItems.addAll(its);
                    } else {
                        newItems.addAll(event.getItems());
                    }
                    items.removeAll(filteredItems);
                    items.addAll(newItems);
                }
            } else if (bl.getType() == Material.DROPPER) {
                ArrayList<ItemStack> filteredItems;
                ChangedSign sign = Pipes.getSignOnPiston(bl);
                HashSet<ItemStack> pFilters = new HashSet<ItemStack>();
                HashSet<ItemStack> pExceptions = new HashSet<ItemStack>();
                if (sign != null) {
                    for (String line3 : RegexUtil.COMMA_PATTERN.split(sign.getLine(2))) {
                        pFilters.add(ItemSyntax.getItem(line3.trim()));
                    }
                    for (String line4 : RegexUtil.COMMA_PATTERN.split(sign.getLine(3))) {
                        pExceptions.add(ItemSyntax.getItem(line4.trim()));
                    }
                    pFilters.removeAll(Collections.singleton(null));
                    pExceptions.removeAll(Collections.singleton(null));
                }
                if ((filteredItems = new ArrayList<ItemStack>(VerifyUtil.withoutNulls(ItemUtil.filterItems(items, pFilters, pExceptions)))).isEmpty()) continue;
                Dropper dropper = (Dropper)bl.getState();
                ArrayList newItems = new ArrayList(dropper.getInventory().addItem(filteredItems.toArray(new ItemStack[filteredItems.size()])).values());
                for (ItemStack stack : dropper.getInventory().getContents()) {
                    if (!ItemUtil.isStackValid(stack)) continue;
                    for (int i = 0; i < stack.getAmount(); ++i) {
                        dropper.drop();
                    }
                }
                items.removeAll(filteredItems);
                items.addAll(newItems);
            }
            if (items.isEmpty()) continue;
            for (int x = -1; x < 2; ++x) {
                for (int y = -1; y < 2; ++y) {
                    for (int z = -1; z < 2; ++z) {
                        Block off;
                        if (items.isEmpty()) {
                            return;
                        }
                        if (!this.pipesDiagonal) {
                            if (x != 0 && y != 0 || x != 0 && z != 0 || y != 0 && z != 0) {
                                continue;
                            }
                        } else {
                            boolean xIsZ;
                            boolean xIsY = Math.abs(x) == Math.abs(y);
                            boolean bl2 = xIsZ = Math.abs(x) == Math.abs(z);
                            if (xIsY && xIsZ) {
                                if (this.pipeInsulator.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)bl.getRelative(x, 0, 0).getBlockData())) && this.pipeInsulator.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)bl.getRelative(0, y, 0).getBlockData())) && this.pipeInsulator.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)bl.getRelative(0, 0, z).getBlockData()))) {
                                    continue;
                                }
                            } else if (xIsY) {
                                if (this.pipeInsulator.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)bl.getRelative(x, 0, 0).getBlockData())) && this.pipeInsulator.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)bl.getRelative(0, y, 0).getBlockData()))) {
                                    continue;
                                }
                            } else if (!xIsZ ? this.pipeInsulator.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)bl.getRelative(0, y, 0).getBlockData())) && this.pipeInsulator.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)bl.getRelative(0, 0, z).getBlockData())) : this.pipeInsulator.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)bl.getRelative(x, 0, 0).getBlockData())) && this.pipeInsulator.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)bl.getRelative(0, 0, z).getBlockData()))) continue;
                        }
                        if (!Pipes.isValidPipeBlock(off = bl.getRelative(x, y, z)) || visitedPipes.contains(off.getLocation().toVector())) continue;
                        visitedPipes.add(off.getLocation().toVector());
                        if (ItemUtil.isStainedGlass(bl.getType()) && ItemUtil.isStainedGlass(off.getType()) && bl.getType() != off.getType()) continue;
                        if (off.getType() == Material.GLASS || ItemUtil.isStainedGlass(off.getType())) {
                            searchQueue.add(off);
                            continue;
                        }
                        if (off.getType() == Material.GLASS_PANE || ItemUtil.isStainedGlassPane(off.getType())) {
                            Block offsetBlock = off.getRelative(x, y, z);
                            if (!Pipes.isValidPipeBlock(offsetBlock) || visitedPipes.contains(offsetBlock.getLocation().toVector()) || ItemUtil.isStainedGlassPane(off.getType()) && ((ItemUtil.isStainedGlass(bl.getType()) || ItemUtil.isStainedGlassPane(bl.getType())) && ItemUtil.getStainedColor(off.getType()) != ItemUtil.getStainedColor(offsetBlock.getType()) || (ItemUtil.isStainedGlass(offsetBlock.getType()) || ItemUtil.isStainedGlassPane(offsetBlock.getType())) && ItemUtil.getStainedColor(off.getType()) != ItemUtil.getStainedColor(offsetBlock.getType()))) continue;
                            visitedPipes.add(offsetBlock.getLocation().toVector());
                            searchQueue.add(off.getRelative(x, y, z));
                            continue;
                        }
                        if (off.getType() != Material.PISTON) continue;
                        searchQueue.addFirst(off);
                    }
                }
            }
        }
    }

    private static boolean isValidPipeBlock(Block block) {
        switch (block.getType()) {
            case GLASS: 
            case PISTON: 
            case STICKY_PISTON: 
            case DROPPER: 
            case GLASS_PANE: {
                return true;
            }
        }
        return ItemUtil.isStainedGlass(block.getType()) || ItemUtil.isStainedGlassPane(block.getType()) || SignUtil.isWallSign(block);
    }

    private void startPipe(Block block, List<ItemStack> items, boolean request) {
        HashSet<ItemStack> filters = new HashSet<ItemStack>();
        HashSet<ItemStack> exceptions = new HashSet<ItemStack>();
        ChangedSign sign = Pipes.getSignOnPiston(block);
        if (sign != null) {
            for (String line3 : RegexUtil.COMMA_PATTERN.split(sign.getLine(2))) {
                filters.add(ItemSyntax.getItem(line3.trim()));
            }
            for (String line4 : RegexUtil.COMMA_PATTERN.split(sign.getLine(3))) {
                exceptions.add(ItemSyntax.getItem(line4.trim()));
            }
        }
        filters.removeAll(Collections.singleton(null));
        exceptions.removeAll(Collections.singleton(null));
        HashSet<Vector> visitedPipes = new HashSet<Vector>();
        if (block.getType() == Material.STICKY_PISTON) {
            PipeSuckEvent event;
            List<ItemStack> leftovers = new ArrayList<ItemStack>();
            Piston p = (Piston)block.getBlockData();
            Block fac = block.getRelative(p.getFacing());
            if (fac.getType() == Material.CHEST || fac.getType() == Material.TRAPPED_CHEST || fac.getType() == Material.DROPPER || fac.getType() == Material.DISPENSER || fac.getType() == Material.HOPPER) {
                for (ItemStack stack : ((InventoryHolder)fac.getState()).getInventory().getContents()) {
                    if (!ItemUtil.isStackValid(stack) || !ItemUtil.doesItemPassFilters(stack, filters, exceptions)) continue;
                    items.add(stack);
                    ((InventoryHolder)fac.getState()).getInventory().removeItem(new ItemStack[]{stack});
                    if (this.pipeStackPerPull) break;
                }
                event = new PipeSuckEvent(block, new ArrayList<ItemStack>(items), fac);
                Bukkit.getPluginManager().callEvent((Event)event);
                items.clear();
                items.addAll(event.getItems());
                if (!event.isCancelled()) {
                    visitedPipes.add(fac.getLocation().toVector());
                    this.searchNearbyPipes(block, visitedPipes, items);
                }
                if (!items.isEmpty()) {
                    for (ItemStack item : items) {
                        if (item == null) continue;
                        leftovers.addAll(((InventoryHolder)fac.getState()).getInventory().addItem(new ItemStack[]{item}).values());
                    }
                }
            } else if (fac.getType() == Material.FURNACE) {
                Furnace f = (Furnace)fac.getState();
                if (!ItemUtil.doesItemPassFilters(f.getInventory().getResult(), filters, exceptions)) {
                    return;
                }
                items.add(f.getInventory().getResult());
                if (f.getInventory().getResult() != null) {
                    f.getInventory().setResult(null);
                }
                PipeSuckEvent event2 = new PipeSuckEvent(block, new ArrayList<ItemStack>(items), fac);
                Bukkit.getPluginManager().callEvent((Event)event2);
                items.clear();
                items.addAll(event2.getItems());
                if (!event2.isCancelled()) {
                    visitedPipes.add(fac.getLocation().toVector());
                    this.searchNearbyPipes(block, visitedPipes, items);
                }
                if (!items.isEmpty()) {
                    for (ItemStack item : items) {
                        if (item == null) continue;
                        if (f.getInventory().getResult() == null) {
                            f.getInventory().setResult(item);
                            continue;
                        }
                        leftovers.add(ItemUtil.addToStack(f.getInventory().getResult(), item));
                    }
                } else {
                    f.getInventory().setResult(null);
                }
            } else if (fac.getType() == Material.JUKEBOX) {
                Jukebox juke = (Jukebox)fac.getState();
                if (juke.getPlaying() != Material.AIR) {
                    items.add(new ItemStack(juke.getPlaying()));
                    PipeSuckEvent event3 = new PipeSuckEvent(block, new ArrayList<ItemStack>(items), fac);
                    Bukkit.getPluginManager().callEvent((Event)event3);
                    items.clear();
                    items.addAll(event3.getItems());
                    if (!event3.isCancelled()) {
                        visitedPipes.add(fac.getLocation().toVector());
                        this.searchNearbyPipes(block, visitedPipes, items);
                    }
                    if (!items.isEmpty()) {
                        for (ItemStack item : items) {
                            if (!ItemUtil.isStackValid(item)) continue;
                            block.getWorld().dropItem(BlockUtil.getBlockCentre(block), item);
                        }
                    } else {
                        juke.setPlaying(Material.AIR);
                        juke.update();
                    }
                }
            } else {
                event = new PipeSuckEvent(block, new ArrayList<ItemStack>(items), fac);
                Bukkit.getPluginManager().callEvent((Event)event);
                items.clear();
                items.addAll(event.getItems());
                if (!event.isCancelled() && !items.isEmpty()) {
                    visitedPipes.add(fac.getLocation().toVector());
                    this.searchNearbyPipes(block, visitedPipes, items);
                }
                leftovers.addAll(items);
            }
            PipeFinishEvent fEvent = new PipeFinishEvent(block, leftovers, fac, request);
            Bukkit.getPluginManager().callEvent((Event)fEvent);
            leftovers = fEvent.getItems();
            items.clear();
            if (!leftovers.isEmpty()) {
                for (ItemStack item : leftovers) {
                    if (!ItemUtil.isStackValid(item)) continue;
                    block.getWorld().dropItemNaturally(block.getLocation().add(0.5, 0.5, 0.5), item);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (event.getBlock().getType() == Material.STICKY_PISTON) {
            ChangedSign sign = Pipes.getSignOnPiston(event.getBlock());
            if (this.pipeRequireSign && sign == null) {
                return;
            }
            if (!EventUtil.passesFilter((Event)event)) {
                return;
            }
            this.startPipe(event.getBlock(), new ArrayList<ItemStack>(), false);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPipeRequest(PipeRequestEvent event) {
        if (event.getBlock().getType() == Material.STICKY_PISTON) {
            ChangedSign sign = Pipes.getSignOnPiston(event.getBlock());
            if (this.pipeRequireSign && sign == null) {
                return;
            }
            if (!EventUtil.passesFilter((Event)event)) {
                return;
            }
            this.startPipe(event.getBlock(), event.getItems(), true);
        }
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "allow-diagonal", "Allow pipes to work diagonally. Required for insulators to work.");
        this.pipesDiagonal = config.getBoolean(path + "allow-diagonal", false);
        config.setComment(path + "insulator-block", "When pipes work diagonally, this block allows the pipe to be insulated to not work diagonally.");
        this.pipeInsulator = BlockSyntax.getBlock(config.getString(path + "insulator-block", BlockTypes.WHITE_WOOL.getId()), true);
        config.setComment(path + "stack-per-move", "This option stops the pipes taking the entire chest on power, and makes it just take a single stack.");
        this.pipeStackPerPull = config.getBoolean(path + "stack-per-move", true);
        config.setComment(path + "require-sign", "Requires pipes to have a [Pipe] sign connected to them. This is the only way to require permissions to make pipes.");
        this.pipeRequireSign = config.getBoolean(path + "require-sign", false);
    }
}

