/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.minecart.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartBlockMechanism;
import com.sk89q.craftbook.mechanics.minecart.events.CartBlockImpactEvent;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.CartUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.block.BlockTypes;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Minecart;
import org.bukkit.event.EventHandler;

public class CartLift
extends CartBlockMechanism {
    @EventHandler
    public void onVehicleImpact(CartBlockImpactEvent event) {
        ChangedSign state;
        String testLine;
        if (!event.getBlocks().matches(this.getMaterial())) {
            return;
        }
        if (!event.getBlocks().hasSign()) {
            return;
        }
        if (event.isMinor()) {
            return;
        }
        if (!event.getBlocks().matches("cartlift up") && !event.getBlocks().matches("cartlift down")) {
            return;
        }
        Minecart cart = (Minecart)event.getVehicle();
        boolean up = event.getBlocks().matches("cartlift up");
        Block destination = event.getBlocks().sign;
        BlockFace face = up ? BlockFace.UP : BlockFace.DOWN;
        do {
            if (destination.getLocation().getBlockY() <= 0 && !up) {
                return;
            }
            if (destination.getLocation().getBlockY() < destination.getWorld().getMaxHeight() - 1 || !up) continue;
            return;
        } while (!SignUtil.isSign(destination = destination.getRelative(face)) || event.getBlocks().base.getType() != destination.getRelative(BlockFace.UP, 1).getType() || !(testLine = (state = CraftBookBukkitUtil.toChangedSign(destination)).getLine(1)).equalsIgnoreCase("[CartLift Up]") && !testLine.equalsIgnoreCase("[CartLift Down]") && !testLine.equalsIgnoreCase("[CartLift]"));
        destination = destination.getRelative(BlockFace.UP, 2);
        CartUtil.teleport(cart, new Location(destination.getWorld(), (double)destination.getX(), (double)destination.getY(), (double)destination.getZ(), cart.getLocation().getYaw(), cart.getLocation().getPitch()));
    }

    @Override
    public String getName() {
        return "CartLift";
    }

    @Override
    public String[] getApplicableSigns() {
        return new String[]{"CartLift Up", "CartLift Down", "CartLift"};
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "block", "Sets the block that is the base of the elevator mechanic.");
        this.material = BlockSyntax.getBlock(config.getString(path + "block", BlockTypes.NETHER_BRICKS.getId()), true);
    }
}

