/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.minecart.blocks;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartBlockMechanism;
import com.sk89q.craftbook.mechanics.minecart.events.CartBlockImpactEvent;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.ItemInfo;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.RailUtil;
import com.sk89q.craftbook.util.RedstoneUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.Tuple2;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.bukkit.block.Chest;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CartDeposit
extends CartBlockMechanism {
    @EventHandler
    public void onVehicleImpact(CartBlockImpactEvent event) {
        if (event.isMinor()) {
            return;
        }
        if (!event.getBlocks().matches(this.getMaterial())) {
            return;
        }
        if (!(event.getMinecart() instanceof StorageMinecart)) {
            return;
        }
        if (RedstoneUtil.Power.OFF == CartDeposit.isActive(event.getBlocks())) {
            return;
        }
        if (!event.getBlocks().hasSign()) {
            return;
        }
        if (!event.getBlocks().matches("collect") && !event.getBlocks().matches("deposit")) {
            return;
        }
        boolean collecting = event.getBlocks().matches("collect");
        ArrayList<Tuple2<ItemInfo, Integer>> items = new ArrayList<Tuple2<ItemInfo, Integer>>();
        for (String data : RegexUtil.COMMA_PATTERN.split(event.getBlocks().getSign().getLine(2))) {
            int itemID = -1;
            int n = -1;
            int amount = -1;
            try {
                String[] splitLine = RegexUtil.COLON_PATTERN.split(RegexUtil.ASTERISK_PATTERN.split(data)[0]);
                itemID = Integer.parseInt(splitLine[0]);
                if (splitLine.length > 1) {
                    n = Short.parseShort(splitLine[1]);
                }
                try {
                    amount = Integer.parseInt(RegexUtil.ASTERISK_PATTERN.split(data)[1]);
                }
                catch (Exception exception) {}
            }
            catch (Exception ignored) {
                continue;
            }
            items.add(new Tuple2<ItemInfo, Integer>(new ItemInfo(itemID, n), amount));
        }
        Inventory cartinventory = ((StorageMinecart)event.getMinecart()).getInventory();
        ArrayList leftovers = new ArrayList();
        ArrayList<Chest> containers = new ArrayList<Chest>(RailUtil.getNearbyChests(event.getBlocks().base));
        containers.addAll(RailUtil.getNearbyChests(event.getBlocks().rail));
        if (containers.isEmpty()) {
            return;
        }
        if (collecting) {
            ArrayList<Object> transferItems = new ArrayList<Object>();
            if (!items.isEmpty()) {
                for (ItemStack item : cartinventory.getContents()) {
                    if (!ItemUtil.isStackValid(item)) continue;
                    Iterator iter = items.iterator();
                    while (iter.hasNext()) {
                        Tuple2 inf = (Tuple2)iter.next();
                        if (((ItemInfo)inf.a).isTypeValid() && ((ItemInfo)inf.a).getType() != item.getType() || ((ItemInfo)inf.a).getData() >= 0 && ((ItemInfo)inf.a).getData() != item.getDurability()) continue;
                        if ((Integer)inf.b < 0) {
                            transferItems.add(item.clone());
                            cartinventory.remove(item);
                            continue;
                        }
                        ItemStack stack = item.clone();
                        if (item.getAmount() > (Integer)inf.b) {
                            stack.setAmount(((Integer)inf.b).intValue());
                            iter.remove();
                            items.add(new Tuple2<ItemInfo, Integer>((ItemInfo)inf.a, 0));
                        } else {
                            iter.remove();
                            items.add(new Tuple2<ItemInfo, Integer>((ItemInfo)inf.a, (Integer)inf.b - stack.getAmount()));
                        }
                        transferItems.add(stack.clone());
                        cartinventory.removeItem(new ItemStack[]{stack});
                    }
                }
            } else {
                transferItems.addAll(Arrays.asList(cartinventory.getContents()));
                cartinventory.clear();
            }
            transferItems.removeAll(Collections.singleton(null));
            if (transferItems.isEmpty()) {
                return;
            }
            CraftBookPlugin.logDebugMessage("collecting " + transferItems.size() + " item stacks", "cart-deposit.collect");
            for (ItemStack itemStack : transferItems) {
                CraftBookPlugin.logDebugMessage("collecting " + itemStack.getAmount() + " items of type " + itemStack.getType().toString(), "cart-deposit.collect");
            }
            for (Chest chest : containers) {
                if (transferItems.isEmpty()) break;
                Inventory containerinventory = chest.getInventory();
                leftovers.addAll(containerinventory.addItem(transferItems.toArray(new ItemStack[transferItems.size()])).values());
                transferItems.clear();
                transferItems.addAll(leftovers);
                leftovers.clear();
            }
            CraftBookPlugin.logDebugMessage("collected items. " + transferItems.size() + " stacks left over.", "cart-deposit.collect");
            leftovers.addAll(cartinventory.addItem(transferItems.toArray(new ItemStack[transferItems.size()])).values());
            transferItems.clear();
            transferItems.addAll(leftovers);
            leftovers.clear();
            CraftBookPlugin.logDebugMessage("collection done. " + transferItems.size() + " stacks wouldn't fit back.", "cart-deposit.collect");
        } else {
            ArrayList<Object> transferitems = new ArrayList<Object>();
            for (Chest chest : containers) {
                Inventory containerinventory = chest.getInventory();
                if (!items.isEmpty()) {
                    for (ItemStack item : containerinventory.getContents()) {
                        if (!ItemUtil.isStackValid(item)) continue;
                        Iterator iter = items.iterator();
                        while (iter.hasNext()) {
                            Tuple2 inf = (Tuple2)iter.next();
                            if (((ItemInfo)inf.a).isTypeValid() && ((ItemInfo)inf.a).getType() != item.getType() || ((ItemInfo)inf.a).getData() >= 0 && ((ItemInfo)inf.a).getData() != item.getDurability()) continue;
                            if ((Integer)inf.b < 0) {
                                transferitems.add(item.clone());
                                containerinventory.remove(item);
                                continue;
                            }
                            ItemStack stack = item.clone();
                            if (item.getAmount() > (Integer)inf.b) {
                                stack.setAmount(((Integer)inf.b).intValue());
                                iter.remove();
                                items.add(new Tuple2<ItemInfo, Integer>((ItemInfo)inf.a, 0));
                            } else {
                                iter.remove();
                                items.add(new Tuple2<ItemInfo, Integer>((ItemInfo)inf.a, (Integer)inf.b - stack.getAmount()));
                            }
                            transferitems.add(stack.clone());
                            containerinventory.removeItem(new ItemStack[]{stack});
                        }
                    }
                    continue;
                }
                transferitems.addAll(Arrays.asList(containerinventory.getContents()));
                containerinventory.clear();
            }
            transferitems.removeAll(Collections.singleton(null));
            if (transferitems.isEmpty()) {
                return;
            }
            CraftBookPlugin.logDebugMessage("depositing " + transferitems.size() + " stacks", "cart-deposit.deposit");
            for (ItemStack itemStack : transferitems) {
                CraftBookPlugin.logDebugMessage("depositing " + itemStack.getAmount() + " items oftype " + itemStack.getType().toString(), "cart-deposit.deposit");
            }
            leftovers.addAll(cartinventory.addItem(transferitems.toArray(new ItemStack[transferitems.size()])).values());
            transferitems.clear();
            transferitems.addAll(leftovers);
            leftovers.clear();
            CraftBookPlugin.logDebugMessage("deposited, " + transferitems.size() + " items left over.", "cart-deposit.deposit");
            for (Chest chest : containers) {
                if (transferitems.isEmpty()) break;
                Inventory containerinventory = chest.getInventory();
                leftovers.addAll(containerinventory.addItem(transferitems.toArray(new ItemStack[transferitems.size()])).values());
                containerinventory.clear();
                for (ItemStack item : leftovers) {
                    containerinventory.addItem(new ItemStack[]{item});
                }
                transferitems.clear();
                transferitems.addAll(leftovers);
                leftovers.clear();
            }
            CraftBookPlugin.logDebugMessage("deposit done. " + transferitems.size() + " items wouldn't fit back.", "cart-deposit.deposit");
        }
    }

    @Override
    public String getName() {
        return "Deposit";
    }

    @Override
    public String[] getApplicableSigns() {
        return new String[]{"Collect", "Deposit"};
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "block", "Sets the block that is the base of the deposit mechanic.");
        this.material = BlockSyntax.getBlock(config.getString(path + "block", BlockTypes.IRON_ORE.getId()), true);
    }
}

