/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.minecart;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.RailUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import org.bukkit.entity.Minecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.util.Vector;

public class VisionSteering
extends AbstractCraftBookMechanic {
    private int minimumSensitivity;

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!event.getPlayer().isInsideVehicle()) {
            return;
        }
        if (!(event.getPlayer().getVehicle() instanceof Minecart)) {
            return;
        }
        if (Math.abs((double)event.getFrom().getYaw() - (double)event.getTo().getYaw()) < (double)this.minimumSensitivity) {
            return;
        }
        if (RailUtil.isTrack(event.getPlayer().getVehicle().getLocation().getBlock().getType())) {
            return;
        }
        Vector direction = event.getPlayer().getLocation().getDirection();
        direction = direction.normalize();
        direction.setY(0);
        direction = direction.multiply(event.getPlayer().getVehicle().getVelocity().length());
        direction.setY(event.getPlayer().getVehicle().getVelocity().getY());
        event.getPlayer().getVehicle().setVelocity(direction);
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "minimum-sensitivity", "Sets the sensitivity of Vision Steering.");
        this.minimumSensitivity = config.getInt(path + "minimum-sensitivity", 3);
    }
}

