/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.minecart;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Minecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.material.Attachable;
import org.bukkit.material.Vine;
import org.bukkit.util.Vector;

public class MoreRails
extends AbstractCraftBookMechanic {
    public static MoreRails instance;
    public boolean ladder;
    private double ladderVerticalVelocity;
    public boolean pressurePlate;

    @Override
    public boolean enable() {
        instance = this;
        return true;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleMove(VehicleMoveEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!(event.getVehicle() instanceof Minecart)) {
            return;
        }
        if (this.pressurePlate && (event.getTo().getBlock().getType() == Material.STONE_PRESSURE_PLATE || Tag.WOODEN_PRESSURE_PLATES.isTagged((Keyed)event.getTo().getBlock().getType()) || event.getTo().getBlock().getType() == Material.HEAVY_WEIGHTED_PRESSURE_PLATE || event.getTo().getBlock().getType() == Material.LIGHT_WEIGHTED_PRESSURE_PLATE)) {
            event.getVehicle().setVelocity(event.getVehicle().getVelocity().normalize().multiply(4));
        }
        if (this.ladder) {
            if (event.getTo().getBlock().getType() == Material.LADDER) {
                Attachable ladder = (Attachable)event.getTo().getBlock().getState().getData();
                Vector velocity = new Vector(0.0, this.ladderVerticalVelocity, (double)((Attachable)event.getTo().getBlock().getState().getData()).getAttachedFace().getModZ());
                if (velocity.length() > ((Minecart)event.getVehicle()).getMaxSpeed()) {
                    double length = velocity.length() / ((Minecart)event.getVehicle()).getMaxSpeed();
                    velocity.setX(velocity.getX() / length);
                    velocity.setY(velocity.getY() / length);
                    velocity.setZ(velocity.getZ() / length);
                }
                velocity.add(new Vector(ladder.getAttachedFace().getModX(), 0, ladder.getAttachedFace().getModZ()));
                event.getVehicle().setVelocity(event.getVehicle().getVelocity().add(velocity));
            } else if (event.getTo().getBlock().getType() == Material.VINE) {
                BlockFace movementFace = BlockFace.SELF;
                Vine vine = (Vine)event.getTo().getBlock().getState().getData();
                for (BlockFace test : LocationUtil.getDirectFaces()) {
                    if (!vine.isOnFace(test)) continue;
                    movementFace = test;
                    break;
                }
                if (movementFace == BlockFace.SELF) {
                    return;
                }
                Vector velocity = new Vector(0.0, this.ladderVerticalVelocity, 0.0);
                if (velocity.length() > ((Minecart)event.getVehicle()).getMaxSpeed()) {
                    double length = velocity.length() / ((Minecart)event.getVehicle()).getMaxSpeed();
                    velocity.setX(velocity.getX() / length);
                    velocity.setY(velocity.getY() / length);
                    velocity.setZ(velocity.getZ() / length);
                }
                velocity.add(new Vector(movementFace.getModX(), 0, movementFace.getModZ()));
                event.getVehicle().setVelocity(event.getVehicle().getVelocity().add(velocity));
            }
        }
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "pressure-plate-intersection", "Enables the pressure plate as an intersection.");
        this.pressurePlate = config.getBoolean(path + "pressure-plate-intersection", false);
        config.setComment(path + "ladder-vertical-rail", "Enables the ladder as a vertical rail.");
        this.ladder = config.getBoolean(path + "ladder-vertical-rail", false);
        config.setComment(path + "ladder-vertical-rail-velocity", "Sets the velocity applied to the minecart on vertical rails.");
        this.ladderVerticalVelocity = config.getDouble(path + "ladder-vertical-rail-velocity", 0.5);
    }
}

