/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.minecart;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import org.bukkit.entity.Minecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.util.Vector;

public class FallModifier
extends AbstractCraftBookMechanic {
    private double verticalSpeed;
    private double horizontalSpeed;
    private Vector fallSpeed;

    @Override
    public void disable() {
        this.fallSpeed = null;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleCreate(VehicleCreateEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!(event.getVehicle() instanceof Minecart)) {
            return;
        }
        ((Minecart)event.getVehicle()).setFlyingVelocityMod(this.fallSpeed);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleMove(VehicleMoveEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!(event.getVehicle() instanceof Minecart)) {
            return;
        }
        ((Minecart)event.getVehicle()).setFlyingVelocityMod(this.fallSpeed);
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "vertical-fall-speed", "Sets the vertical fall speed of the minecart");
        this.verticalSpeed = config.getDouble(path + "vertical-fall-speed", 0.9);
        config.setComment(path + "horizontal-fall-speed", "Sets the horizontal fall speed of the minecart");
        this.horizontalSpeed = config.getDouble(path + "horizontal-fall-speed", 1.1);
        this.fallSpeed = new Vector(this.horizontalSpeed, this.verticalSpeed, this.horizontalSpeed);
    }
}

