/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.minecart;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.mechanics.minecart.TemporaryCart;
import com.sk89q.craftbook.util.CartUtil;
import com.sk89q.craftbook.util.EntityUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ExitRemover
extends AbstractCraftBookMechanic {
    private boolean giveItem;

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleExit(VehicleExitEvent event) {
        if (!(event.getVehicle() instanceof RideableMinecart)) {
            return;
        }
        if (event.getVehicle().isDead() || !event.getVehicle().isValid()) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (CraftBookPlugin.inst().isMechanicEnabled(TemporaryCart.class) && ((TemporaryCart)CraftBookPlugin.inst().getMechanic(TemporaryCart.class)).getMinecarts().contains(event.getVehicle())) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> {
            if (event.getVehicle().isDead() || !event.getVehicle().isValid()) {
                return;
            }
            if (this.giveItem) {
                ItemStack stack = CartUtil.getCartStack((Minecart)event.getVehicle());
                if (event.getExited() instanceof Player) {
                    if (!((Player)event.getExited()).getInventory().addItem(new ItemStack[]{stack}).isEmpty() && ((Player)event.getExited()).getGameMode() != GameMode.CREATIVE) {
                        event.getExited().getWorld().dropItemNaturally(event.getExited().getLocation(), stack);
                    }
                } else if (event.getExited() != null) {
                    event.getExited().getWorld().dropItemNaturally(event.getExited().getLocation(), stack);
                }
            }
            EntityUtil.killEntity((Entity)event.getVehicle());
        }, 2L);
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "give-item", "Sets whether to give the player the item back or not.");
        this.giveItem = config.getBoolean(path + "give-item", false);
    }
}

