/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.weather;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.util.SearchArea;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class TimeFaker
extends AbstractSelfTriggeredIC {
    private Set<String> players;
    SearchArea area;
    long time;

    public TimeFaker(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Time Faker";
    }

    @Override
    public String getSignTitle() {
        return "TIME FAKER";
    }

    @Override
    public void load() {
        block2: {
            this.players = new HashSet<String>();
            this.area = SearchArea.createArea(this.getLocation().getBlock(), this.getLine(2));
            try {
                this.time = Long.parseLong(this.getSign().getLine(3));
            }
            catch (Exception e) {
                if (this.time != 0L) break block2;
                this.time = 13000L;
            }
        }
    }

    @Override
    public boolean isAlwaysST() {
        return true;
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (this.area.isWithinArea(p.getLocation())) {
                    p.setPlayerTime(this.time, false);
                    this.players.add(p.getName());
                    continue;
                }
                if (!this.players.contains(p.getName())) continue;
                this.players.remove(p.getName());
                p.resetPlayerTime();
            }
        } else {
            for (String p : this.players) {
                Player pp = Bukkit.getPlayerExact((String)p);
                if (pp == null) continue;
                pp.resetPlayerTime();
            }
            this.players.clear();
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new TimeFaker(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Radius based fake time.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"radius", "time"};
        }
    }
}

