/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.weather;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractIC;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import org.bukkit.Server;

public class TimeControlAdvanced
extends AbstractIC {
    public TimeControlAdvanced(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Advanced Time Control";
    }

    @Override
    public String getSignTitle() {
        return "ADV TIME CONTROL";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.isTriggered(0) && chip.getInput(0)) {
            int time = chip.getInput(1) ? 24000 : 16000;
            CraftBookBukkitUtil.toSign(this.getSign()).getWorld().setTime((long)time);
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "Day on Low, Night on High", "Nothing", "Nothing"};
        }

        @Override
        public IC create(ChangedSign sign) {
            return new TimeControlAdvanced(this.getServer(), sign, this);
        }
    }
}

