/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.util.InventoryUtil;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SearchArea;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PlayerInventorySensor
extends AbstractSelfTriggeredIC {
    SearchArea area;
    ItemStack item;
    int minPlayers;
    int slot;
    boolean inHand;

    public PlayerInventorySensor(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void think(ChipState chip) {
        chip.setOutput(0, this.isDetected());
    }

    @Override
    public String getTitle() {
        return "Player Inventory Sensor";
    }

    @Override
    public String getSignTitle() {
        return "PLAYER INV SENSOR";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.isDetected());
        }
    }

    @Override
    public void load() {
        this.area = SearchArea.createArea(CraftBookBukkitUtil.toSign(this.getSign()).getBlock(), this.getLine(2));
        String[] parts = RegexUtil.EQUALS_PATTERN.split(this.getLine(3));
        this.item = ItemUtil.makeItemValid(ItemSyntax.getItem(parts[0]));
        if (parts.length > 1) {
            String[] data = RegexUtil.COLON_PATTERN.split(parts[1]);
            try {
                this.minPlayers = Integer.parseInt(data[0]);
                this.inHand = Boolean.parseBoolean(data[1]);
                try {
                    this.slot = Integer.parseInt(data[2]);
                }
                catch (Exception e) {
                    this.slot = -1;
                }
            }
            catch (Exception e) {
                if (this.minPlayers <= 0) {
                    this.minPlayers = 1;
                }
                this.inHand = false;
            }
        } else {
            this.minPlayers = 1;
            this.inHand = false;
            this.slot = -1;
        }
    }

    public boolean isDetected() {
        int players = 0;
        for (Player e : this.area.getPlayersInArea()) {
            if (e == null || !e.isValid()) continue;
            if (this.testPlayer(e)) {
                ++players;
            }
            if (players < this.minPlayers) continue;
            return true;
        }
        return false;
    }

    public boolean testPlayer(Player e) {
        if (this.slot == -1 && !this.inHand) {
            return InventoryUtil.doesInventoryContain((Inventory)e.getInventory(), false, this.item);
        }
        if (this.inHand) {
            return e.getInventory().getItemInMainHand() != null && ItemUtil.areItemsIdentical(e.getInventory().getItemInMainHand(), this.item) && e.getInventory().getItemInMainHand().getAmount() >= this.item.getAmount() || e.getInventory().getItemInOffHand() != null && ItemUtil.areItemsIdentical(e.getInventory().getItemInOffHand(), this.item) && e.getInventory().getItemInOffHand().getAmount() >= this.item.getAmount();
        }
        if (this.slot > -1) {
            return e.getInventory().getItem(this.slot) != null && ItemUtil.areItemsIdentical(e.getInventory().getItem(this.slot), this.item) && e.getInventory().getItem(this.slot).getAmount() >= this.item.getAmount();
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new PlayerInventorySensor(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Detects if a certain number of players have an item in their inventory.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"+oSearchArea", "item=minPlayers:inHand:slot"};
        }
    }
}

