/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.util.EntityType;
import com.sk89q.craftbook.util.ICUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.worldedit.math.Vector3;
import java.util.Locale;
import java.util.Set;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;

public class MovementSensor
extends AbstractSelfTriggeredIC {
    private Set<EntityType> types;
    private Block center;
    private Vector3 radius;

    public MovementSensor(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        this.types = EntityType.getDetected(this.getSign().getLine(3).trim());
        if (this.types.isEmpty()) {
            this.types.add(EntityType.ANY);
        }
        this.getSign().setLine(3, this.getSign().getLine(3).toUpperCase(Locale.ENGLISH));
        this.radius = ICUtil.parseRadius(this.getSign());
        String radiusString = this.radius.getX() + "," + this.radius.getY() + "," + this.radius.getZ();
        if (this.radius.getX() == this.radius.getY() && this.radius.getY() == this.radius.getZ()) {
            radiusString = String.valueOf(this.radius.getX());
        }
        if (this.getSign().getLine(2).contains("=")) {
            this.getSign().setLine(2, radiusString + "=" + RegexUtil.EQUALS_PATTERN.split(this.getSign().getLine(2))[1]);
            this.center = ICUtil.parseBlockLocation(this.getSign());
        } else {
            this.getSign().setLine(2, radiusString);
            this.center = this.getBackBlock();
        }
        this.getSign().update(false);
    }

    @Override
    public String getTitle() {
        return "Movement Sensor";
    }

    @Override
    public String getSignTitle() {
        return "MOVING SENSOR";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.check());
        }
    }

    @Override
    public void think(ChipState chip) {
        this.check();
    }

    public boolean check() {
        block0: for (Entity entity : LocationUtil.getNearbyEntities(this.center.getLocation(), this.radius)) {
            if (!entity.isValid()) continue;
            for (EntityType type : this.types) {
                if (!type.is(entity)) continue;
                if (!LocationUtil.isWithinRadius(this.center.getLocation(), entity.getLocation(), this.radius) || !(entity.getVelocity().lengthSquared() >= 0.01)) continue block0;
                return true;
            }
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new MovementSensor(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Outputs high if a nearby entity is moving.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"radius=x:y:z offset", "entity type"};
        }
    }
}

