/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.util.ICUtil;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Location;
import org.bukkit.Server;

public class LightSensor
extends AbstractSelfTriggeredIC {
    Location centre;
    byte min;

    public LightSensor(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Light Sensor";
    }

    @Override
    public String getSignTitle() {
        return "LIGHT SENSOR";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.hasLight());
        }
    }

    @Override
    public void think(ChipState chip) {
        chip.setOutput(0, this.hasLight());
    }

    @Override
    public void load() {
        this.centre = !this.getLine(3).isEmpty() ? ICUtil.parseBlockLocation(this.getSign(), 3).getLocation() : SignUtil.getBackBlock(CraftBookBukkitUtil.toSign(this.getSign()).getBlock()).getLocation().add(0.0, 1.0, 0.0);
        try {
            this.min = Byte.parseByte(this.getSign().getLine(2));
        }
        catch (Exception e) {
            this.min = (byte)10;
            try {
                this.getSign().setLine(2, Integer.toString(this.min));
                this.getSign().update(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean hasLight() {
        byte lightLevel = this.centre.getBlock().getLightLevel();
        return lightLevel >= this.min;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new LightSensor(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Outputs high if specific block is above specified light level.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"minimum light", "x:y:z offset"};
        }
    }
}

