/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.util.EntityType;
import com.sk89q.craftbook.util.SearchArea;
import java.util.Set;
import org.bukkit.Server;
import org.bukkit.entity.Entity;

public class EntitySensor
extends AbstractSelfTriggeredIC {
    private Set<EntityType> types;
    private SearchArea area;
    private short minimum;
    private short minMode;

    public EntitySensor(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public void load() {
        this.types = EntityType.getDetected(this.getLine(3).split("<")[0].trim().split("<=")[0].trim().split(">=")[0].trim().split("==")[0].trim().split(">")[0].trim());
        this.minMode = this.getLine(3).contains(">=") ? (short)0 : (this.getLine(3).contains("==") ? (short)1 : (this.getLine(3).contains(">") ? (short)2 : (this.getLine(3).contains("<=") ? (short)3 : (this.getLine(3).contains("<") ? (short)4 : (short)0))));
        try {
            this.minimum = this.minMode == 0 ? Short.parseShort(this.getLine(3).split(">=")[1].trim()) : (this.minMode == 1 ? Short.parseShort(this.getLine(3).split("==")[1].trim()) : (this.minMode == 2 ? Short.parseShort(this.getLine(3).split(">")[1].trim()) : (this.minMode == 3 ? Short.parseShort(this.getLine(3).split("<=")[1].trim()) : Short.parseShort(this.getLine(3).split("<")[1].trim()))));
        }
        catch (Exception e) {
            this.minimum = 1;
        }
        this.area = SearchArea.createArea(CraftBookBukkitUtil.toSign(this.getSign()).getBlock(), this.getLine(2));
    }

    @Override
    public String getTitle() {
        return "Entity Sensor";
    }

    @Override
    public String getSignTitle() {
        return "ENTITY SENSOR";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.isDetected());
        }
    }

    @Override
    public void think(ChipState state) {
        state.setOutput(0, this.isDetected());
    }

    protected boolean isDetected() {
        short cur = 0;
        for (Entity entity : this.area.getEntitiesInArea(this.types)) {
            if (!entity.isValid()) continue;
            for (EntityType type : this.types) {
                if (!type.is(entity)) continue;
                cur = (short)(cur + 1);
            }
        }
        if (this.minMode == 0 && cur >= this.minimum) {
            return true;
        }
        if (this.minMode == 1 && cur == this.minimum) {
            return true;
        }
        if (this.minMode == 2 && cur > this.minimum) {
            return true;
        }
        if (this.minMode == 3 && cur <= this.minimum) {
            return true;
        }
        return this.minMode == 4 && cur < this.minimum;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new EntitySensor(this.getServer(), sign, this);
        }

        @Override
        public void verify(ChangedSign sign) throws ICVerificationException {
            if (!SearchArea.isValidArea(CraftBookBukkitUtil.toSign(sign).getBlock(), sign.getLine(2))) {
                throw new ICVerificationException("Invalid SearchArea on 3rd line!");
            }
        }

        @Override
        public String getShortDescription() {
            return "Detects specific entity types in a given radius.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"SearchArea", "Entity Types{(>=|==|>)minimum}"};
        }
    }
}

