/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.util.ICUtil;
import com.sk89q.craftbook.util.InventoryUtil;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.ItemUtil;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class ContentsSensor
extends AbstractSelfTriggeredIC {
    boolean checkAmount;
    ItemStack item;
    int slot;
    Block offset;

    public ContentsSensor(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        this.checkAmount = this.getLine(2).contains("*");
        this.item = ItemSyntax.getItem(this.getLine(2));
        if (this.getLine(3).isEmpty()) {
            this.slot = -1;
        } else {
            try {
                this.slot = Integer.parseInt(this.getLine(3));
            }
            catch (Exception e) {
                this.slot = -1;
            }
        }
        this.offset = this.getLine(3).contains("=") ? ICUtil.parseBlockLocation(this.getSign(), 3) : this.getBackBlock().getRelative(BlockFace.UP);
    }

    @Override
    public String getTitle() {
        return "Container Content Sensor";
    }

    @Override
    public String getSignTitle() {
        return "CONTENT SENSOR";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.sense());
        }
    }

    @Override
    public void think(ChipState chip) {
        chip.setOutput(0, this.sense());
    }

    public boolean sense() {
        if (InventoryUtil.doesBlockHaveInventory(this.offset)) {
            InventoryHolder inv = (InventoryHolder)this.offset.getState();
            int amount = 0;
            if (this.slot < 0 || this.slot > inv.getInventory().getContents().length) {
                for (ItemStack cont : inv.getInventory().getContents()) {
                    if (!ItemUtil.areItemsIdentical(cont, this.item)) continue;
                    if (this.checkAmount) {
                        if ((amount += cont.getAmount()) < this.item.getAmount()) continue;
                        return true;
                    }
                    return true;
                }
            } else {
                return ItemUtil.areItemsIdentical(this.item, inv.getInventory().getItem(this.slot)) && (!this.checkAmount || inv.getInventory().getItem(this.slot).getAmount() >= this.item.getAmount());
            }
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new ContentsSensor(this.getServer(), sign, this);
        }

        @Override
        public void verify(ChangedSign sign) throws ICVerificationException {
            ItemStack item = ItemSyntax.getItem(sign.getLine(2));
            if (item == null) {
                throw new ICVerificationException("Invalid item to detect!");
            }
        }

        @Override
        public String getShortDescription() {
            return "Detects if the above container has a specific item inside it.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"item id:data", "slot (optional)=offset"};
        }
    }
}

