/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.RadioStation;
import com.sk89q.craftbook.util.SearchArea;
import com.sk89q.craftbook.util.jinglenote.Playlist;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class RadioPlayer
extends AbstractSelfTriggeredIC {
    String band;
    SearchArea area;
    Map<String, SearchArea> listening;

    public RadioPlayer(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        this.band = this.getLine(2);
        this.area = !this.getLine(3).isEmpty() ? SearchArea.createArea(this.getLocation().getBlock(), this.getLine(3)) : SearchArea.createEmptyArea();
        this.listening = new HashMap<String, SearchArea>();
    }

    @Override
    public String getTitle() {
        return "Radio Player";
    }

    @Override
    public String getSignTitle() {
        return "RADIO PLAYER";
    }

    @Override
    public boolean isAlwaysST() {
        return true;
    }

    @Override
    public void trigger(ChipState chip) {
        Playlist playlist = RadioStation.getPlaylist(this.band);
        if (playlist == null) {
            return;
        }
        if (chip.getInput(0)) {
            if (this.area.getPlayersInArea().size() != this.listening.size()) {
                HashMap<String, SearchArea> removals = new HashMap<String, SearchArea>();
                for (Map.Entry<String, SearchArea> entry : this.listening.entrySet()) {
                    boolean found = false;
                    for (Player p : this.area.getPlayersInArea()) {
                        if (!p.getName().equals(entry.getKey())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    removals.put(entry.getKey(), entry.getValue());
                }
                if (removals.size() > 0) {
                    playlist.getPlaylistInterpreter().removePlayers(removals);
                    for (String string : removals.keySet()) {
                        this.listening.remove(string);
                    }
                }
                boolean changed = false;
                for (Player player : this.area.getPlayersInArea()) {
                    if (this.listening.containsKey(player.getName())) continue;
                    this.listening.put(player.getName(), this.area);
                    changed = true;
                }
                if (changed) {
                    playlist.getPlaylistInterpreter().addPlayers(this.listening);
                }
                CraftBookPlugin.logDebugMessage("Reset listener list! Size of: " + this.listening.size(), "ic-mc1277");
            }
        } else if (this.listening.size() > 0) {
            playlist.getPlaylistInterpreter().removePlayers(this.listening);
            this.listening.clear();
            CraftBookPlugin.logDebugMessage("Cleared listener list!", "ic-mc1277");
        }
        chip.setOutput(0, playlist.isPlaying() && !this.listening.isEmpty());
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new RadioPlayer(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Plays a radio station.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"Radio Band", "Radius"};
        }
    }
}

