/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.util.EntityType;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SearchArea;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionInducer
extends AbstractSelfTriggeredIC {
    SearchArea area;
    Set<EntityType> types;
    PotionEffect effect;

    public PotionInducer(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Potion Inducer";
    }

    @Override
    public String getSignTitle() {
        return "POTION INDUCER";
    }

    @Override
    public void load() {
        int effectTime;
        int effectAmount;
        int effectID;
        String[] effectInfo = RegexUtil.COLON_PATTERN.split(RegexUtil.EQUALS_PATTERN.split(this.getLine(2), 2)[0], 3);
        try {
            effectID = Integer.parseInt(effectInfo[0]);
        }
        catch (Exception e) {
            effectID = 1;
        }
        try {
            effectAmount = Integer.parseInt(effectInfo[1]);
        }
        catch (Exception e) {
            effectAmount = 1;
        }
        try {
            effectTime = Integer.parseInt(effectInfo[2]);
        }
        catch (Exception e) {
            effectTime = 10;
        }
        this.effect = new PotionEffect(PotionEffectType.getById((int)effectID), effectTime * 20, effectAmount - 1, true);
        try {
            this.types = EntityType.getDetected(RegexUtil.EQUALS_PATTERN.split(this.getLine(2), 2)[1]);
        }
        catch (Exception e) {
            this.types = EnumSet.of(EntityType.PLAYER);
        }
        boolean converting = false;
        if (this.getRawLine(3).toLowerCase().endsWith("p") && (!this.getRawLine(2).contains("=") || converting)) {
            this.getSign().setLine(2, this.getRawLine(2) + (!this.getRawLine(2).contains("=") ? "=p" : "p"));
            this.getSign().setLine(3, this.getRawLine(3).substring(0, this.getRawLine(3).length() - 1));
            converting = true;
        }
        if (this.getRawLine(3).toLowerCase().endsWith("m") && (!this.getRawLine(2).contains("=") || converting)) {
            this.getSign().setLine(2, this.getRawLine(2) + (!this.getRawLine(2).contains("=") ? "=m" : "m"));
            this.getSign().setLine(3, this.getRawLine(3).substring(0, this.getRawLine(3).length() - 1));
            converting = true;
        }
        if (this.getRawLine(3).toLowerCase().endsWith("p") && (!this.getRawLine(2).contains("=") || converting)) {
            this.getSign().setLine(2, this.getRawLine(2) + (!this.getRawLine(2).contains("=") ? "=p" : "p"));
            this.getSign().setLine(3, this.getRawLine(3).substring(0, this.getRawLine(3).length() - 1));
            converting = true;
        }
        if (converting) {
            this.getSign().update(false);
        }
        this.area = SearchArea.createArea(CraftBookBukkitUtil.toSign(this.getSign()).getBlock(), this.getLine(3));
    }

    public boolean induce() {
        boolean value = false;
        for (Entity entity : this.area.getEntitiesInArea(this.types)) {
            if (!entity.isValid() || !(entity instanceof LivingEntity)) continue;
            LivingEntity liv = (LivingEntity)entity;
            liv.addPotionEffect(this.effect, true);
            value = true;
        }
        return value;
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.induce());
        }
    }

    @Override
    public void think(ChipState state) {
        if (!state.getInput(0)) {
            state.setOutput(0, this.induce());
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new PotionInducer(this.getServer(), sign, this);
        }

        @Override
        public void verify(ChangedSign sign) throws ICVerificationException {
            try {
                String[] bits = RegexUtil.COLON_PATTERN.split(sign.getLine(2), 3);
                int effectId = Integer.parseInt(bits[0]);
                if (PotionEffectType.getById((int)effectId) == null) {
                    throw new ICVerificationException("The third line must be a valid potion effect id.");
                }
            }
            catch (NumberFormatException e) {
                throw new ICVerificationException("The third line must be a valid potion effect id.");
            }
        }

        @Override
        public String getShortDescription() {
            return "Gives nearby entities a potion effect.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"id:level:time=entitytypes", "range=offset"};
        }
    }
}

