/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.util.ICUtil;
import com.sk89q.craftbook.util.RegexUtil;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Server;

public class ParticleEffect
extends AbstractSelfTriggeredIC {
    int effectID;
    int effectData;
    int times;
    Location offset;

    public ParticleEffect(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Particle Effect";
    }

    @Override
    public String getSignTitle() {
        return "PARTICLE EFFECT";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.doEffect();
        }
    }

    @Override
    public void think(ChipState state) {
        if (state.getInput(0)) {
            this.doEffect();
        }
    }

    @Override
    public void load() {
        String[] eff = RegexUtil.COLON_PATTERN.split(RegexUtil.EQUALS_PATTERN.split(this.getSign().getLine(2))[0], 2);
        try {
            this.effectID = Integer.parseInt(eff[0]);
        }
        catch (Exception e) {
            try {
                this.effectID = Effect.valueOf((String)eff[0]).getId();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Effect.getById((int)this.effectID) == null) {
            return;
        }
        try {
            this.effectData = Integer.parseInt(eff[1]);
        }
        catch (Exception e) {
            this.effectData = 0;
        }
        try {
            this.times = Integer.parseInt(this.getSign().getLine(3));
        }
        catch (Exception ignored) {
            this.times = 1;
        }
        if (this.getLine(2).contains("=")) {
            String extra = this.getLine(2).split("=")[1];
            this.getSign().setLine(2, this.getLine(2).split("=")[0]);
            this.getSign().setLine(3, this.getLine(3) + "=" + extra);
            this.getSign().update(false);
        }
        this.offset = this.getLine(3).contains("=") ? ICUtil.parseBlockLocation(this.getSign(), 3).getLocation() : this.getBackBlock().getLocation().add(0.0, 1.0, 0.0);
    }

    public void doEffect() {
        if (this.effectID == 0) {
            return;
        }
        for (int i = 0; i < this.times; ++i) {
            this.offset.getWorld().playEffect(this.offset, Effect.getById((int)this.effectID), this.effectData, 50);
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new ParticleEffect(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Creates particle effects.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"effectID:effectData=xOff:yOff:zOff", "amount of particles=offset"};
        }

        @Override
        public void verify(ChangedSign sign) throws ICVerificationException {
            try {
                String[] eff = RegexUtil.COLON_PATTERN.split(RegexUtil.EQUALS_PATTERN.split(sign.getLine(2))[0], 2);
                int effectID = 0;
                try {
                    effectID = Integer.parseInt(eff[0]);
                }
                catch (Exception e) {
                    try {
                        effectID = Effect.valueOf((String)eff[0]).getId();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (Effect.getById((int)effectID) == null) {
                    throw new ICVerificationException("Invalid effect!");
                }
                try {
                    int effectData = Integer.parseInt(eff[1]);
                }
                catch (Exception e) {
                    boolean bl = false;
                }
            }
            catch (Exception e) {
                throw new ICVerificationException("Invalid effect!");
            }
        }
    }
}

