/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.ConfigurableIC;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICManager;
import com.sk89q.craftbook.mechanics.ic.ICMechanic;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SearchArea;
import com.sk89q.craftbook.util.jinglenote.JingleNoteManager;
import com.sk89q.craftbook.util.jinglenote.MidiJingleSequencer;
import com.sk89q.util.yaml.YAMLProcessor;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiUnavailableException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Melody
extends AbstractSelfTriggeredIC {
    SearchArea area;
    File file;
    String midiName;
    boolean forceStart;
    boolean loop;
    boolean hasRun;
    MelodyPlayer player;
    boolean foundFile = false;

    public Melody(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Melody Player";
    }

    @Override
    public String getSignTitle() {
        return "MELODY";
    }

    @Override
    public boolean isAlwaysST() {
        return true;
    }

    @Override
    public void unload() {
        if (this.player != null && this.player.isPlaying()) {
            this.player.setPlaying(false);
        }
        this.player = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void load() {
        File[] trialPaths;
        if (this.getLine(3).contains(":START")) {
            this.getSign().setLine(3, this.getLine(3).replace(":START", ";START"));
        }
        if (this.getLine(3).contains(":LOOP")) {
            this.getSign().setLine(3, this.getLine(3).replace(":LOOP", ";LOOP"));
        }
        String[] split = RegexUtil.SEMICOLON_PATTERN.split(this.getSign().getLine(3));
        if (!this.getLine(3).isEmpty()) {
            if (!SearchArea.isValidArea(this.getLocation().getBlock(), split[0])) return;
            this.area = SearchArea.createArea(this.getLocation().getBlock(), split[0]);
        } else {
            this.area = SearchArea.createEmptyArea();
        }
        for (int i = 1; i < split.length; ++i) {
            if (split[i].toUpperCase(Locale.ENGLISH).contains("START")) {
                this.forceStart = true;
                continue;
            }
            if (!split[i].toUpperCase(Locale.ENGLISH).contains("LOOP")) continue;
            this.loop = true;
        }
        this.midiName = this.getSign().getLine(2);
        for (File f : trialPaths = new File[]{new File(ICManager.inst().getMidiFolder(), this.midiName), new File(ICManager.inst().getMidiFolder(), this.midiName + ".mid"), new File(ICManager.inst().getMidiFolder(), this.midiName + ".midi"), new File("midi", this.midiName), new File("midi", this.midiName + ".mid"), new File("midi", this.midiName + ".midi")}) {
            if (!f.exists()) continue;
            this.file = f;
            break;
        }
        if (this.file != null && this.file.exists()) {
            this.foundFile = true;
            return;
        } else {
            CraftBookPlugin.logDebugMessage("Midi file not found in melody IC: " + this.midiName, "midi");
        }
    }

    @Override
    public void trigger(ChipState chip) {
        if (!this.foundFile || this.area == null) {
            return;
        }
        if (this.player == null || !this.player.isValid() && (this.loop || chip.isTriggered(0) && chip.getInput(0))) {
            try {
                this.player = new MelodyPlayer(new MidiJingleSequencer(this.file, this.loop));
                this.hasRun = false;
            }
            catch (IOException | InvalidMidiDataException | MidiUnavailableException e) {
                CraftBookPlugin.logger().warning("Found invalid MIDI file: " + this.file);
                e.printStackTrace();
                this.foundFile = false;
            }
        }
        if (this.player == null) {
            return;
        }
        if (chip.getInput(0)) {
            if (this.player.isPlaying() || !this.hasRun) {
                for (Player pp : this.getServer().getOnlinePlayers()) {
                    if (this.player.isPlaying(pp.getName()) && !this.area.isWithinArea(pp.getLocation())) {
                        this.player.stop(pp.getName());
                        continue;
                    }
                    if (this.player.isPlaying(pp.getName()) || !this.area.isWithinArea(pp.getLocation())) continue;
                    this.player.play(pp.getName());
                    if (((Factory)this.getFactory()).showPlayingMessage) {
                        pp.sendMessage(ChatColor.YELLOW + "Playing " + this.midiName + "...");
                    }
                    if (this.hasRun) continue;
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.getPlugin(), (Runnable)this.player);
                    this.hasRun = true;
                }
            }
        } else if (!chip.getInput(0) && !this.forceStart) {
            this.player.setPlaying(false);
        }
        chip.setOutput(0, this.player.isPlaying());
    }

    public static class Factory
    extends AbstractICFactory
    implements ConfigurableIC {
        private boolean showPlayingMessage;

        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new Melody(this.getServer(), sign, this);
        }

        @Override
        public void checkPlayer(ChangedSign sign, CraftBookPlayer player) throws ICVerificationException {
            if (sign.getLine(3).trim().isEmpty() && !ICMechanic.hasRestrictedPermissions(player, this, "mc1270")) {
                throw new ICVerificationException("You don't have permission to globally broadcast!");
            }
        }

        @Override
        public String getShortDescription() {
            return "Plays the MIDI file entered on the sign.";
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"The '''MC1270''' will play a MIDI file listed on the IC in a specified area, or globally. It can be set to loop, or for the input to only play the MIDI file and not turn it off.", "", "This IC is one of the MIDI playing ICs, and can only play a single MIDI file, if you would like to play a playlist see [[../MC1273|The Jukebox IC]]", "", "MIDI files are stored in the CraftBook MIDI folder, which is inside the 'plugins/CraftBook' folder. This folder is only generated when ICs are enabled, so if you are missing the folder that is why.", "In the main plugin configuration, there is an option to enable percussion. Some percussion instruments will still be played when this is disabled, but the seperate percussion portion of the MIDI file will not be read."};
        }

        @Override
        public void addConfiguration(YAMLProcessor config, String path) {
            this.showPlayingMessage = config.getBoolean(path + "show-playing-message", true);
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"MIDI name", "SearchArea;LOOP;START"};
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Play/Stop the MIDI", "High if currently playing"};
        }
    }

    private class MelodyPlayer
    implements Runnable {
        private JingleNoteManager jNote;
        private MidiJingleSequencer sequencer;
        private boolean isPlaying;
        private final Set<String> toStop;
        private final Set<String> toPlay;

        public MelodyPlayer(MidiJingleSequencer sequencer) {
            this.sequencer = sequencer;
            this.jNote = new JingleNoteManager();
            this.toStop = new HashSet<String>();
            this.toPlay = new HashSet<String>();
            this.isPlaying = false;
            CraftBookPlugin.logDebugMessage("Constructing new player instance.", "ic-mc1270");
        }

        public boolean isPlaying(String player) {
            return this.isPlaying() && (this.toPlay.contains(player) || this.jNote.isPlaying(player));
        }

        public void stop(String player) {
            this.toStop.add(player);
            this.toPlay.remove(player);
            CraftBookPlugin.logDebugMessage("Removing " + player + " from melody IC.", "ic-mc1270");
        }

        public void play(String player) {
            if (this.jNote.isPlaying(player) || this.toPlay.contains(player)) {
                return;
            }
            this.toPlay.add(player);
            this.toStop.remove(player);
            CraftBookPlugin.logDebugMessage("Adding " + player + " to melody IC.", "ic-mc1270");
        }

        public boolean isPlaying() {
            return this.isPlaying && this.sequencer != null && (this.sequencer.isPlaying() || !this.sequencer.hasPlayedBefore());
        }

        public void setPlaying(boolean playing) {
            this.isPlaying = playing;
        }

        @Override
        public void run() {
            try {
                this.isPlaying = true;
                CraftBookPlugin.logDebugMessage("Starting run of player instance.", "ic-mc1270");
                while (this.isPlaying) {
                    for (String player : this.toStop) {
                        this.jNote.stop(player);
                    }
                    this.toStop.clear();
                    for (String player : this.toPlay) {
                        this.jNote.play(player, this.sequencer, Melody.this.area);
                    }
                    this.toPlay.clear();
                    if (this.isValid() && (this.isPlaying() || !this.sequencer.hasPlayedBefore())) continue;
                    this.isPlaying = false;
                    break;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                if (this.sequencer != null) {
                    this.sequencer.stop();
                }
                this.jNote.stopAll();
                this.sequencer = null;
                this.toPlay.clear();
                this.toStop.clear();
                this.isPlaying = false;
            }
        }

        public boolean isValid() {
            return this.sequencer != null && (this.sequencer.isPlaying() || !this.sequencer.hasPlayedBefore());
        }
    }
}

