/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractIC;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.util.ICUtil;
import com.sk89q.worldedit.math.BlockVector3;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;

public class LightningSummon
extends AbstractIC {
    private Location center;
    private BlockVector3 radius;
    private int chance;

    public LightningSummon(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        if (!this.getLine(2).isEmpty()) {
            this.radius = ICUtil.parseRadius(this.getSign()).toBlockPoint();
            this.center = this.getLine(2).contains("=") ? ICUtil.parseBlockLocation(this.getSign()).getLocation() : this.getBackBlock().getLocation();
        } else {
            this.center = this.getBackBlock().getLocation();
            this.radius = BlockVector3.at((int)1, (int)1, (int)1);
        }
        if (!this.getLine(3).isEmpty()) {
            try {
                this.chance = Math.min(Integer.parseInt(this.getLine(3)), 100);
            }
            catch (Exception e) {
                this.chance = 100;
            }
        } else {
            this.chance = 100;
        }
    }

    @Override
    public String getTitle() {
        return "Zeus Bolt";
    }

    @Override
    public String getSignTitle() {
        return "ZEUS BOLT";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            for (int x = -this.radius.getBlockX() + 1; x < this.radius.getBlockX(); ++x) {
                for (int y = -this.radius.getBlockY() + 1; y < this.radius.getBlockY(); ++y) {
                    for (int z = -this.radius.getBlockZ() + 1; z < this.radius.getBlockZ(); ++z) {
                        int rx = this.center.getBlockX() - x;
                        int ry = this.center.getBlockY() - y;
                        int rz = this.center.getBlockZ() - z;
                        Block b = CraftBookBukkitUtil.toSign(this.getSign()).getWorld().getBlockAt(rx, ry, rz);
                        if (b.getType() == Material.AIR || CraftBookPlugin.inst().getRandom().nextInt(100) > this.chance) continue;
                        b.getWorld().strikeLightning(b.getLocation());
                    }
                }
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new LightningSummon(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Strike location with lightning!";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"+oradius=x:y:z block offset", "+ochance"};
        }
    }
}

