/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractIC;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.SmallFireball;
import org.bukkit.util.Vector;

public class FireShooter
extends AbstractIC {
    private double speed;
    private double spread;
    private double vert;

    public FireShooter(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        try {
            String[] velocity = RegexUtil.COLON_PATTERN.split(this.getSign().getLine(2).trim());
            this.speed = Double.parseDouble(velocity[0]);
            this.spread = Double.parseDouble(velocity[1]);
            this.vert = Double.parseDouble(this.getSign().getLine(3).trim());
        }
        catch (Exception e) {
            this.speed = 1.6f;
            this.spread = 12.0;
            this.vert = 0.2f;
            this.getSign().setLine(2, this.speed + ":" + this.spread);
            this.getSign().setLine(3, String.valueOf(this.vert));
            this.getSign().update(false);
        }
        if (this.speed > 10.0) {
            this.speed = 10.0;
        } else if (this.speed < 0.1) {
            this.speed = 0.1f;
        }
        if (this.spread > 5000.0) {
            this.spread = 5000.0;
        } else if (this.spread < 0.0) {
            this.spread = 0.0;
        }
        if (this.vert > 100.0) {
            this.vert = 100.0;
        } else if (this.vert < -100.0) {
            this.vert = -100.0;
        }
    }

    @Override
    public String getTitle() {
        return "Fire Shooter";
    }

    @Override
    public String getSignTitle() {
        return "FIRE SHOOTER";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.shootFire(1);
        }
    }

    public void shootFire(int n) {
        Block signBlock = CraftBookBukkitUtil.toSign(this.getSign()).getBlock();
        BlockFace face = SignUtil.getBack(signBlock);
        Block targetDir = signBlock.getRelative(face).getRelative(face);
        double x = targetDir.getX() - signBlock.getX();
        double z = targetDir.getZ() - signBlock.getZ();
        Location shootLoc = new Location(CraftBookBukkitUtil.toSign(this.getSign()).getWorld(), (double)targetDir.getX() + 0.5, (double)targetDir.getY() + 0.5, (double)targetDir.getZ() + 0.5);
        if (!shootLoc.getChunk().isLoaded()) {
            return;
        }
        for (int i = 0; i < n; i = (int)((short)(i + 1))) {
            double f2 = Math.sqrt(x * x + this.vert * this.vert + z * z);
            double nx = x / f2;
            double ny = this.vert / f2;
            double nz = z / f2;
            nx += CraftBookPlugin.inst().getRandom().nextGaussian() * (double)0.0075f * this.spread;
            ny += CraftBookPlugin.inst().getRandom().nextGaussian() * (double)0.0075f * this.spread;
            nz += CraftBookPlugin.inst().getRandom().nextGaussian() * (double)0.0075f * this.spread;
            float f3 = (float)Math.sqrt((nx *= this.speed) * nx + (nz *= this.speed) * nz);
            SmallFireball f = (SmallFireball)CraftBookBukkitUtil.toSign(this.getSign()).getWorld().spawn(shootLoc, SmallFireball.class);
            f.setVelocity(new Vector(nx, ny *= this.speed, nz));
            f.getLocation().setYaw((float)(Math.atan2(nx, nz) * 180.0 / 3.1415927410125732));
            f.getLocation().setPitch((float)(Math.atan2(ny, f3) * 180.0 / 3.1415927410125732));
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new FireShooter(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Shoots a fireball.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"speed:spread", "vertical gain"};
        }
    }
}

