/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.FireShooter;
import org.bukkit.Server;

public class FireBarrage
extends FireShooter {
    public FireBarrage(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Fire Barrage";
    }

    @Override
    public String getSignTitle() {
        return "FIRE BARRAGE";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.shootFire(5);
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new FireBarrage(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Shoots a barrage of fire.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"speed:spread", "vertical gain"};
        }
    }
}

