/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.entity;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICMechanic;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.util.HistoryHashMap;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.PlayerType;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SearchArea;
import com.sk89q.craftbook.util.Tuple2;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class TeleportTransmitter
extends AbstractSelfTriggeredIC {
    protected static final HistoryHashMap<String, Tuple2<Long, String>> memory = new HistoryHashMap(50);
    protected static HistoryHashMap<String, Location> lastKnownLocations = new HistoryHashMap(50);
    protected String band;
    SearchArea area;
    PlayerType type;
    String typeData;

    public TeleportTransmitter(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Teleport Transmitter";
    }

    @Override
    public String getSignTitle() {
        return "TELEPORT OUT";
    }

    @Override
    public void load() {
        this.band = RegexUtil.PIPE_PATTERN.split(this.getLine(2))[0];
        if (this.getLine(2).contains("|")) {
            this.type = PlayerType.getFromChar(RegexUtil.PIPE_PATTERN.split(this.getLine(2))[1].charAt(0));
            this.typeData = RegexUtil.COLON_PATTERN.split(RegexUtil.PIPE_PATTERN.split(this.getLine(2))[1])[1];
        }
        this.area = SearchArea.createArea(CraftBookBukkitUtil.toSign(this.getSign()).getBlock(), this.getLine(3));
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.sendPlayer());
        }
    }

    @Override
    public void think(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.sendPlayer());
        }
    }

    public boolean sendPlayer() {
        Player closest = null;
        for (Player e : this.area.getPlayersInArea()) {
            if (e == null || !e.isValid() || e.isDead() || this.type != null && !this.type.doesPlayerPass(e, this.typeData)) continue;
            if (closest == null) {
                closest = e;
            }
            if (this.area.getCenter() == null) break;
            if (!(LocationUtil.getDistanceSquared(closest.getLocation(), this.area.getCenter()) >= LocationUtil.getDistanceSquared(e.getLocation(), this.area.getCenter()))) continue;
            closest = e;
        }
        if (closest != null && lastKnownLocations.containsKey(this.band)) {
            ((Location)lastKnownLocations.get(this.band)).getChunk().load();
        }
        if (closest == null || TeleportTransmitter.setValue(this.band, new Tuple2<Long, String>(System.currentTimeMillis(), closest.getName()))) {
            return true;
        }
        closest.sendMessage(ChatColor.RED + "This Teleporter Frequency is currently busy! Try again soon (3s)!");
        return false;
    }

    public static Tuple2<Long, String> getValue(String band) {
        long time;
        int seconds;
        if (memory.containsKey(band) && (seconds = (int)((time = System.currentTimeMillis() - (Long)((Tuple2)TeleportTransmitter.memory.get((Object)band)).a) / 1000L) % 60) > 5) {
            memory.remove(band);
            return null;
        }
        Tuple2 val = (Tuple2)memory.get(band);
        memory.remove(band);
        return val;
    }

    public static boolean setValue(String band, Tuple2<Long, String> val) {
        if (memory.containsKey(band)) {
            long time = System.currentTimeMillis() - (Long)((Tuple2)TeleportTransmitter.memory.get((Object)band)).a;
            int seconds = (int)(time / 1000L) % 60;
            if (seconds > 3) {
                memory.remove(band);
            } else {
                return false;
            }
        }
        memory.put(band, val);
        return true;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new TeleportTransmitter(this.getServer(), sign, this);
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"The '''MC1112''' teleports a player located within IC's radius to a receiver ([[../MC1113/]]) tuned to the same ''frequency''.", "This IC requires the recieving chunk to be loaded for the initial teleport, future teleports should not require the chunk to be loaded."};
        }

        @Override
        public String getShortDescription() {
            return "Transmitter for the teleportation network.";
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "High on successful teleport queue"};
        }

        @Override
        public void verify(ChangedSign sign) throws ICVerificationException {
            if (!SearchArea.isValidArea(CraftBookBukkitUtil.toSign(sign).getBlock(), sign.getLine(3))) {
                throw new ICVerificationException("Invalid SearchArea on 4th line!");
            }
        }

        @Override
        public void load() {
            if (!ICMechanic.instance.savePersistentData || !CraftBookPlugin.inst().hasPersistentStorage()) {
                return;
            }
            if (CraftBookPlugin.inst().getPersistentStorage().has("teleport-ic-locations.list")) {
                HashSet list = new HashSet((Set)CraftBookPlugin.inst().getPersistentStorage().get("teleport-ic-locations.list"));
                for (String ent : list) {
                    String locString = (String)CraftBookPlugin.inst().getPersistentStorage().get("teleport-ic-locations." + ent);
                    String[] bits = RegexUtil.COLON_PATTERN.split(locString);
                    Location loc = new Location(Bukkit.getWorld((String)bits[0]), Double.parseDouble(bits[1]), Double.parseDouble(bits[2]), Double.parseDouble(bits[3]));
                    lastKnownLocations.put(ent, loc);
                }
            }
        }

        @Override
        public void unload() {
            if (!ICMechanic.instance.savePersistentData || !CraftBookPlugin.inst().hasPersistentStorage()) {
                return;
            }
            CraftBookPlugin.inst().getPersistentStorage().set("teleport-ic-locations.list", new HashSet(lastKnownLocations.keySet()));
            for (Map.Entry locations : lastKnownLocations.entrySet()) {
                if (locations == null || locations.getValue() == null) continue;
                String loc = ((Location)locations.getValue()).getWorld().getName() + ":" + ((Location)locations.getValue()).getBlockX() + ":" + ((Location)locations.getValue()).getBlockY() + ":" + ((Location)locations.getValue()).getBlockZ();
                CraftBookPlugin.inst().getPersistentStorage().set("teleport-ic-locations." + (String)locations.getKey(), loc);
            }
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"Frequency|PlayerType", "SearchArea"};
        }
    }
}

