/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.entity;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.util.EntityType;
import com.sk89q.craftbook.util.EntityUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SearchArea;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.entity.Entity;

public class EntityTrap
extends AbstractSelfTriggeredIC {
    SearchArea area;
    int damage;
    List<EntityType> types;
    boolean erase;

    public EntityTrap(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Entity Trap";
    }

    @Override
    public String getSignTitle() {
        return "ENTITY TRAP";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.hurt());
        }
    }

    @Override
    public void think(ChipState chip) {
        chip.setOutput(0, this.hurt());
    }

    @Override
    public void load() {
        this.area = SearchArea.createArea(CraftBookBukkitUtil.toSign(this.getSign()).getBlock(), this.getLine(2));
        try {
            this.damage = Integer.parseInt(RegexUtil.EQUALS_PATTERN.split(this.getSign().getLine(2))[2]);
        }
        catch (Exception ignored) {
            this.damage = 2;
        }
        this.types = !this.getLine(3).isEmpty() ? new ArrayList<EntityType>(EntityType.getDetected(this.getLine(3))) : Collections.singletonList(EntityType.MOB_HOSTILE);
        if (this.types.isEmpty()) {
            this.types.add(EntityType.ANY);
        }
        this.erase = this.getLine(3).startsWith("!");
    }

    protected boolean hurt() {
        boolean hasHurt = false;
        for (Entity e : this.area.getEntitiesInArea(this.types)) {
            if (this.erase) {
                e.remove();
            } else {
                EntityUtil.damageEntity(e, this.damage);
            }
            hasHurt = true;
        }
        return hasHurt;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new EntityTrap(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Damage nearby entities of type.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"radius=x:y:z=damage", "mob type"};
        }
    }
}

