/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.entity;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.util.EntityType;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.RegexUtil;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class EntityCannon
extends AbstractSelfTriggeredIC {
    double x;
    double y;
    double z;
    EntityType type;
    Location location;

    public EntityCannon(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Entity Cannon";
    }

    @Override
    public String getSignTitle() {
        return "ENTITY CANNON";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.shoot());
        }
    }

    @Override
    public void think(ChipState state) {
        state.setOutput(0, this.shoot());
    }

    @Override
    public void load() {
        this.location = CraftBookBukkitUtil.toSign(this.getSign()).getLocation();
        if (!this.getSign().getLine(3).isEmpty()) {
            this.type = EntityType.fromString(this.getSign().getLine(3));
        }
        if (this.type == null) {
            this.type = EntityType.MOB_HOSTILE;
        }
        try {
            String[] split = RegexUtil.COLON_PATTERN.split(this.getSign().getLine(2));
            this.x = Double.parseDouble(split[0]);
            this.y = Double.parseDouble(split[1]);
            this.z = Double.parseDouble(split[2]);
        }
        catch (Exception e) {
            this.x = 0.0;
            this.y = 1.0;
            this.z = 0.0;
        }
    }

    protected boolean shoot() {
        boolean resultBoolean = false;
        for (Entity e : LocationUtil.getNearbyEntities(this.location, CraftBookBukkitUtil.toVector(new Vector(3, 3, 3)))) {
            if (e.isDead() || !e.isValid() || !this.type.is(e)) continue;
            e.setVelocity(new Vector(this.x, this.y, this.z).add(e.getVelocity()));
            resultBoolean = true;
        }
        return resultBoolean;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new EntityCannon(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Shoots nearby entities of type at set velocity.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"velocity x:y:z", "mob type"};
        }
    }
}

