/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.SearchArea;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.data.type.Cocoa;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class Planter
extends AbstractSelfTriggeredIC {
    ItemStack item;
    SearchArea area;

    public Planter(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public void load() {
        this.item = this.getLine(2).isEmpty() ? null : ItemSyntax.getItem(this.getLine(2));
        this.area = SearchArea.createArea(this.getLocation().getBlock(), this.getLine(3));
    }

    @Override
    public String getTitle() {
        return "Planter";
    }

    @Override
    public String getSignTitle() {
        return "PLANTER";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.plant());
        }
    }

    @Override
    public void think(ChipState state) {
        if (state.getInput(0)) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            this.plant();
        }
    }

    public boolean plant() {
        if (this.item != null && !this.plantableItem(this.item)) {
            return false;
        }
        if (this.getBackBlock().getRelative(0, 1, 0).getType() == Material.CHEST || this.getBackBlock().getRelative(0, 1, 0).getType() == Material.TRAPPED_CHEST) {
            Chest c = (Chest)this.getBackBlock().getRelative(0, 1, 0).getState();
            for (ItemStack it : c.getInventory().getContents()) {
                Block b;
                if (!ItemUtil.isStackValid(it) || !this.plantableItem(it) || this.item != null && !ItemUtil.areItemsIdentical(it, this.item) || (b = this.searchBlocks(it)) == null || !c.getInventory().removeItem(new ItemStack[]{new ItemStack(it.getType(), 1, it.getDurability())}).isEmpty()) continue;
                return this.plantBlockAt(it, b);
            }
        } else {
            for (Entity ent : this.area.getEntitiesInArea()) {
                Item itemEnt;
                ItemStack stack;
                if (!(ent instanceof Item) || !ItemUtil.isStackValid(stack = (itemEnt = (Item)ent).getItemStack()) || this.item != null && !ItemUtil.areItemsIdentical(this.item, stack)) continue;
                Block b = null;
                b = this.searchBlocks(stack);
                if (b == null || !ItemUtil.takeFromItemEntity(itemEnt, 1)) continue;
                return this.plantBlockAt(stack, b);
            }
        }
        return false;
    }

    public Block searchBlocks(ItemStack stack) {
        Block b = this.area.getRandomBlockInArea();
        if (b == null || b.getType() != Material.AIR) {
            return null;
        }
        if (this.itemPlantableAtBlock(stack, b)) {
            return b;
        }
        return null;
    }

    protected boolean plantableItem(ItemStack item) {
        switch (item.getType()) {
            case WHEAT_SEEDS: 
            case NETHER_WART: 
            case MELON_SEEDS: 
            case PUMPKIN_SEEDS: 
            case CACTUS: 
            case POTATO: 
            case CARROT: 
            case POPPY: 
            case DANDELION: 
            case RED_MUSHROOM: 
            case BROWN_MUSHROOM: 
            case LILY_PAD: 
            case BEETROOT_SEEDS: 
            case COCOA_BEANS: {
                return true;
            }
        }
        return Tag.SAPLINGS.isTagged((Keyed)item.getType());
    }

    protected boolean itemPlantableAtBlock(ItemStack item, Block block) {
        switch (item.getType()) {
            case POPPY: 
            case DANDELION: {
                return block.getRelative(0, -1, 0).getType() == Material.DIRT || block.getRelative(0, -1, 0).getType() == Material.GRASS_BLOCK || block.getRelative(0, -1, 0).getType() == Material.PODZOL;
            }
            case WHEAT_SEEDS: 
            case MELON_SEEDS: 
            case PUMPKIN_SEEDS: 
            case POTATO: 
            case CARROT: 
            case BEETROOT_SEEDS: {
                return block.getRelative(0, -1, 0).getType() == Material.FARMLAND;
            }
            case NETHER_WART: {
                return block.getRelative(0, -1, 0).getType() == Material.SOUL_SAND;
            }
            case CACTUS: {
                return block.getRelative(0, -1, 0).getType() == Material.SAND;
            }
            case RED_MUSHROOM: 
            case BROWN_MUSHROOM: {
                return block.getRelative(0, -1, 0).getType().isSolid();
            }
            case LILY_PAD: {
                return block.getRelative(0, -1, 0).getType() == Material.WATER;
            }
            case COCOA_BEANS: {
                BlockFace[] faces;
                for (BlockFace face : faces = new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH}) {
                    if (block.getRelative(face).getType() != Material.JUNGLE_LOG) continue;
                    return true;
                }
                return false;
            }
        }
        if (Tag.SAPLINGS.isTagged((Keyed)item.getType())) {
            return block.getRelative(0, -1, 0).getType() == Material.DIRT || block.getRelative(0, -1, 0).getType() == Material.GRASS_BLOCK || block.getRelative(0, -1, 0).getType() == Material.PODZOL;
        }
        return false;
    }

    protected boolean plantBlockAt(ItemStack item, Block block) {
        switch (item.getType()) {
            case CACTUS: 
            case POPPY: 
            case DANDELION: 
            case RED_MUSHROOM: 
            case BROWN_MUSHROOM: 
            case LILY_PAD: {
                block.setType(item.getType());
                return true;
            }
            case WHEAT_SEEDS: {
                block.setType(Material.WHEAT);
                return true;
            }
            case MELON_SEEDS: {
                block.setType(Material.MELON_STEM);
                return true;
            }
            case PUMPKIN_SEEDS: {
                block.setType(Material.PUMPKIN_STEM);
                return true;
            }
            case NETHER_WART: {
                block.setType(Material.NETHER_WART);
                return true;
            }
            case POTATO: {
                block.setType(Material.POTATOES);
                return true;
            }
            case CARROT: {
                block.setType(Material.CARROTS);
                return true;
            }
            case BEETROOT_SEEDS: {
                block.setType(Material.BEETROOTS);
                return true;
            }
            case COCOA_BEANS: {
                ArrayList<BlockFace> faces = new ArrayList<BlockFace>(Arrays.asList(BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH));
                Collections.shuffle(faces, CraftBookPlugin.inst().getRandom());
                for (BlockFace face : faces) {
                    if (block.getRelative(face).getType() != Material.JUNGLE_LOG) continue;
                    block.setType(Material.COCOA);
                    ((Cocoa)block.getBlockData()).setFacing(face);
                    return true;
                }
                return false;
            }
        }
        if (Tag.SAPLINGS.isTagged((Keyed)item.getType())) {
            block.setType(item.getType());
            return true;
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new Planter(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Plants plantable things at set offset.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"+oItem to plant id{:data}", "SearchArea"};
        }

        @Override
        public void verify(ChangedSign sign) throws ICVerificationException {
            if (!SearchArea.isValidArea(CraftBookBukkitUtil.toSign(sign).getBlock(), sign.getLine(3))) {
                throw new ICVerificationException("Invalid SearchArea on 4th line!");
            }
        }
    }
}

