/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.util.ICUtil;
import com.sk89q.worldedit.math.BlockVector3;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;

public class LiquidFlood
extends AbstractSelfTriggeredIC {
    BlockVector3 radius;
    String liquid;
    Location centre;

    public LiquidFlood(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Liquid Flooder";
    }

    @Override
    public String getSignTitle() {
        return "LIQUID FLOOD";
    }

    @Override
    public void load() {
        this.centre = ICUtil.parseBlockLocation(this.getSign()).getLocation();
        this.radius = ICUtil.parseRadius(this.getSign()).toBlockPoint();
        this.liquid = this.getSign().getLine(2).equalsIgnoreCase("lava") ? "lava" : "water";
    }

    public void doStuff(ChipState chip) {
        block7: {
            block6: {
                if (!chip.getInput(0)) break block6;
                for (int x = -this.radius.getBlockX() + 1; x < this.radius.getBlockX(); ++x) {
                    for (int y = -this.radius.getBlockY() + 1; y < this.radius.getBlockY(); ++y) {
                        for (int z = -this.radius.getBlockZ() + 1; z < this.radius.getBlockZ(); ++z) {
                            int rx = this.centre.getBlockX() - x;
                            int ry = this.centre.getBlockY() - y;
                            int rz = this.centre.getBlockZ() - z;
                            Block b = CraftBookBukkitUtil.toSign(this.getSign()).getWorld().getBlockAt(rx, ry, rz);
                            if (b.getType() != Material.AIR && b.getType() != (this.liquid.equalsIgnoreCase("water") ? Material.WATER : Material.LAVA)) continue;
                            b.setType(this.liquid.equalsIgnoreCase("water") ? Material.WATER : Material.LAVA);
                        }
                    }
                }
                break block7;
            }
            if (chip.getInput(0)) break block7;
            for (int x = -this.radius.getBlockX() + 1; x < this.radius.getBlockX(); ++x) {
                for (int y = -this.radius.getBlockY() + 1; y < this.radius.getBlockY(); ++y) {
                    for (int z = -this.radius.getBlockZ() + 1; z < this.radius.getBlockZ(); ++z) {
                        int rx = this.centre.getBlockX() - x;
                        int ry = this.centre.getBlockY() - y;
                        int rz = this.centre.getBlockZ() - z;
                        Block b = CraftBookBukkitUtil.toSign(this.getSign()).getWorld().getBlockAt(rx, ry, rz);
                        if (b.getType() != (this.liquid.equalsIgnoreCase("water") ? Material.WATER : Material.LAVA)) continue;
                        b.setType(Material.AIR);
                    }
                }
            }
        }
    }

    @Override
    public void trigger(ChipState chip) {
        this.doStuff(chip);
    }

    @Override
    public void think(ChipState state) {
        this.doStuff(state);
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new LiquidFlood(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Floods an area with a liquid.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"+owater/lava", "+oradius=x:y:z offset"};
        }
    }
}

