/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractIC;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.RegexUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.FallingBlock;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class BlockLauncher
extends AbstractIC {
    Vector velocity;
    ItemStack block;

    public BlockLauncher(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Block Launcher";
    }

    @Override
    public String getSignTitle() {
        return "BLOCK LAUNCH";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.launch();
        }
    }

    @Override
    public void load() {
        this.block = ItemUtil.makeItemValid(ItemSyntax.getItem(this.getLine(2)));
        if (this.getLine(2).isEmpty() || this.block == null) {
            this.block = new ItemStack(Material.SAND, 1);
        }
        if (this.getLine(3).isEmpty()) {
            this.velocity = new Vector(0.0, 0.5, 0.0);
        } else {
            String[] split2 = RegexUtil.COLON_PATTERN.split(this.getSign().getLine(3));
            this.velocity = new Vector(Double.parseDouble(split2[0]), Double.parseDouble(split2[1]), Double.parseDouble(split2[2]));
        }
    }

    public void launch() {
        int timeout;
        Block above = this.getBackBlock().getRelative(0, 1, 0);
        for (timeout = 12; above.getType() != Material.AIR || timeout < 0 || above.getLocation().getY() >= 255.0; --timeout) {
            above = above.getRelative(0, 1, 0);
        }
        if (this.velocity.getY() < 0.0) {
            above = this.getBackBlock().getRelative(0, -1, 0);
            for (timeout = 12; above.getType() != Material.AIR || timeout < 0 || above.getLocation().getY() <= 1.0; --timeout) {
                above = above.getRelative(0, -1, 0);
            }
        }
        double y = (double)above.getY() - 0.99;
        if (!new Location(CraftBookBukkitUtil.toSign(this.getSign()).getWorld(), (double)above.getX() + 0.5, y, (double)above.getZ() + 0.5).getChunk().isLoaded()) {
            return;
        }
        FallingBlock block = CraftBookBukkitUtil.toSign(this.getSign()).getWorld().spawnFallingBlock(new Location(CraftBookBukkitUtil.toSign(this.getSign()).getWorld(), (double)above.getX() + 0.5, y, (double)above.getZ() + 0.5), this.block.getType(), this.block.getData().getData());
        block.setVelocity(this.velocity);
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new BlockLauncher(this.getServer(), sign, this);
        }

        @Override
        public void verify(ChangedSign sign) throws ICVerificationException {
            if (!sign.getLine(3).isEmpty()) {
                try {
                    String[] split2 = RegexUtil.COLON_PATTERN.split(sign.getLine(3));
                    new Vector(Double.parseDouble(split2[0]), Double.parseDouble(split2[1]), Double.parseDouble(split2[2]));
                }
                catch (Exception ignored) {
                    throw new ICVerificationException("Velocity must be in x:y:z format!");
                }
            }
        }

        @Override
        public String getShortDescription() {
            return "Launches set block with set velocity.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"id{:data}", "+ovelocity x:y:z"};
        }
    }
}

