/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.blocks;

import com.google.common.collect.Lists;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.ConfigurableIC;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.BlockUtil;
import com.sk89q.craftbook.util.ICUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.blocks.Blocks;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;

public class BlockBreaker
extends AbstractSelfTriggeredIC {
    private Block broken;
    private Block chest;
    private BlockStateHolder item;

    public BlockBreaker(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Block Breaker";
    }

    @Override
    public String getSignTitle() {
        return "BLOCK BREAK";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.breakBlock());
        }
    }

    @Override
    public void think(ChipState state) {
        state.setOutput(0, this.breakBlock());
    }

    @Override
    public void load() {
        this.item = BlockSyntax.getBlock(this.getLine(2), true);
    }

    public boolean breakBlock() {
        if (this.broken == null) {
            Block bl = this.getBackBlock();
            this.broken = ((Factory)this.getFactory()).above ? bl.getRelative(0, -1, 0) : bl.getRelative(0, 1, 0);
        }
        if (this.broken == null || this.broken.getType() == Material.AIR || this.broken.getType() == Material.MOVING_PISTON || Blocks.containsFuzzy(((Factory)this.getFactory()).blockBlacklist, (BlockStateHolder)BukkitAdapter.adapt((BlockData)this.broken.getBlockData()))) {
            return false;
        }
        if (!this.item.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)this.broken.getBlockData()))) {
            ICUtil.collectItem(this, BlockVector3.at((int)0, (int)1, (int)0), BlockUtil.getBlockDrops(this.broken, null));
        }
        this.broken.setType(Material.AIR);
        return true;
    }

    public void dropItem(ItemStack item) {
        CraftBookBukkitUtil.toSign(this.getSign()).getWorld().dropItem(BlockUtil.getBlockCentre(CraftBookBukkitUtil.toSign(this.getSign()).getBlock()), item);
    }

    public static class Factory
    extends AbstractICFactory
    implements ConfigurableIC {
        boolean above;
        List<BaseBlock> blockBlacklist;

        public Factory(Server server, boolean above) {
            super(server);
            this.above = above;
        }

        @Override
        public IC create(ChangedSign sign) {
            return new BlockBreaker(this.getServer(), sign, this);
        }

        @Override
        public void verify(ChangedSign sign) throws ICVerificationException {
            if (!sign.getLine(2).trim().isEmpty()) {
                BaseBlock item = BlockSyntax.getBlock(sign.getLine(2), true);
                if (item == null) {
                    throw new ICVerificationException("An invalid block was provided on line 2!");
                }
                if (Blocks.containsFuzzy(this.blockBlacklist, (BlockStateHolder)item)) {
                    throw new ICVerificationException("A blacklisted block was provided on line 2!");
                }
            }
        }

        @Override
        public String getShortDescription() {
            return "Breaks blocks " + (this.above ? "above" : "below") + " block sign is on.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"+oBlock ID:Data", null};
        }

        @Override
        public void addConfiguration(YAMLProcessor config, String path) {
            config.setComment(path + "blacklist", "Stops the IC from breaking the listed blocks.");
            this.blockBlacklist = BlockSyntax.getBlocks(config.getStringList(path + "blacklist", (List)Lists.newArrayList((Object[])new String[]{BlockTypes.BEDROCK.getId()})), true);
        }
    }
}

