/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.variables;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.BukkitCraftBookPlayer;
import com.sk89q.craftbook.mechanics.ic.AbstractIC;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.mechanics.variables.VariableCommands;
import com.sk89q.craftbook.mechanics.variables.VariableManager;
import com.sk89q.craftbook.util.InventoryUtil;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.RegexUtil;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class ItemCounter
extends AbstractIC {
    String variable;
    ItemStack item;

    public ItemCounter(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Item Counter";
    }

    @Override
    public String getSignTitle() {
        return "ITEM COUNTER";
    }

    @Override
    public void load() {
        this.variable = this.getLine(2);
        this.item = ItemSyntax.getItem(this.getLine(3));
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            int amount = 0;
            if (InventoryUtil.doesBlockHaveInventory(this.getBackBlock().getRelative(0, 1, 0))) {
                InventoryHolder chest = (InventoryHolder)this.getBackBlock().getRelative(0, 1, 0).getState();
                for (ItemStack stack : chest.getInventory().getContents()) {
                    if (!ItemUtil.isStackValid(stack) || this.item != null && !ItemUtil.areItemsIdentical(stack, this.item)) continue;
                    amount += stack.getAmount();
                }
            }
            chip.setOutput(0, amount > 0);
            String var = VariableManager.getVariableName(this.variable);
            String key = VariableManager.getNamespace(this.variable);
            double existing = Double.parseDouble(VariableManager.instance.getVariable(var, key));
            String val = String.valueOf(existing + (double)amount);
            if (val.endsWith(".0")) {
                val = StringUtils.replace((String)val, (String)".0", (String)"");
            }
            VariableManager.instance.setVariable(var, key, val);
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new ItemCounter(this.getServer(), sign, this);
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"The '''VAR200''' IC searches a chest and counts the amounts of all items that match the last line of the sign. ", "The counted amount is then added to the variable listed on the 3rd line."};
        }

        @Override
        public String getShortDescription() {
            return "Adds to a variable the amount of items of a type counted.";
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "High if found item"};
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"Variable Name", "ItemSyntax"};
        }

        @Override
        public void checkPlayer(ChangedSign sign, CraftBookPlayer player) throws ICVerificationException {
            String[] parts = RegexUtil.PIPE_PATTERN.split(sign.getLine(2));
            if (parts.length == 1) {
                if (!VariableCommands.hasVariablePermission((CommandSender)((BukkitCraftBookPlayer)player).getPlayer(), "global", parts[0], "use")) {
                    throw new ICVerificationException("You do not have permissions to use the global variable namespace!");
                }
            } else if (!VariableCommands.hasVariablePermission((CommandSender)((BukkitCraftBookPlayer)player).getPlayer(), parts[0], parts[1], "use")) {
                throw new ICVerificationException("You do not have permissions to use the " + parts[0] + " variable namespace!");
            }
        }

        @Override
        public void verify(ChangedSign sign) throws ICVerificationException {
            String[] parts = RegexUtil.PIPE_PATTERN.split(sign.getLine(2));
            if (parts.length == 1 ? !VariableManager.instance.hasVariable(sign.getLine(2), "global") : !VariableManager.instance.hasVariable(parts[1], parts[0])) {
                throw new ICVerificationException("Unknown Variable!");
            }
        }
    }
}

